```tsx
import { Component, h } from '@stencil/core';

@Component({
  tag: 'chip-example',
  styleUrl: 'chip-example.css'
})
export class ChipExample {
  render() {
    return [
      <ion-chip>
        <ion-label>Default</ion-label>
      </ion-chip>,

      <ion-chip>
        <ion-label color="secondary">Secondary Label</ion-label>
      </ion-chip>,

      <ion-chip color="secondary">
        <ion-label color="dark">Secondary w/ Dark label</ion-label>
      </ion-chip>,

      <ion-chip>
        <ion-icon name="pin"></ion-icon>
        <ion-label>Default</ion-label>
      </ion-chip>,

      <ion-chip>
        <ion-icon name="heart" color="dark"></ion-icon>
        <ion-label>Default</ion-label>
      </ion-chip>,

      <ion-chip>
        <ion-label>Button Chip</ion-label>
        <ion-icon name="close-circle"></ion-icon>
      </ion-chip>,

      <ion-chip>
        <ion-icon name="pin" color="primary"></ion-icon>
        <ion-label>Icon Chip</ion-label>
        <ion-icon name="close"></ion-icon>
      </ion-chip>,

      <ion-chip>
        <ion-avatar>
          <img src="https://gravatar.com/avatar/dba6bae8c566f9d4041fb9cd9ada7741?d=identicon&f=y"/>
        </ion-avatar>
        <ion-label>Avatar Chip</ion-label>
        <ion-icon name="close-circle"></ion-icon>
      </ion-chip>
    ];
  }
}
```