```tsx
import { Component, h } from '@stencil/core';

@Component({
  tag: 'item-divider-example',
  styleUrl: 'item-divider-example.css'
})
export class ItemDividerExample {
  render() {
    return [
      <ion-item-divider>
        <ion-label>
          Basic Item Divider
        </ion-label>
      </ion-item-divider>,

      <ion-item-divider color="secondary">
        <ion-label>
          Secondary Item Divider
        </ion-label>
      </ion-item-divider>,

      //  Item Dividers in a List
      <ion-list>
        <ion-item-divider>
          <ion-label>
            Section A
          </ion-label>
        </ion-item-divider>

        <ion-item><ion-label>A1</ion-label></ion-item>
        <ion-item><ion-label>A2</ion-label></ion-item>
        <ion-item><ion-label>A3</ion-label></ion-item>
        <ion-item><ion-label>A4</ion-label></ion-item>
        <ion-item><ion-label>A5</ion-label></ion-item>

        <ion-item-divider>
          <ion-label>
            Section B
          </ion-label>
        </ion-item-divider>

        <ion-item><ion-label>B1</ion-label></ion-item>
        <ion-item><ion-label>B2</ion-label></ion-item>
        <ion-item><ion-label>B3</ion-label></ion-item>
        <ion-item><ion-label>B4</ion-label></ion-item>
        <ion-item><ion-label>B5</ion-label></ion-item>
      </ion-list>
    ];
  }
}
```