```tsx
import { Component, h } from '@stencil/core';

@Component({
  tag: 'tab-button-example',
  styleUrl: 'tab-button-example.css'
})
export class TabButtonExample {
  render() {
    return [
      <ion-tabs>
        {/* Tab views */}
        <ion-tab tab="schedule">
          <ion-router-outlet name="schedule"></ion-router-outlet>
        </ion-tab>

        <ion-tab tab="speakers">
          <ion-router-outlet name="speakers"></ion-router-outlet>
        </ion-tab>

        <ion-tab tab="map">
          <ion-router-outlet name="map"></ion-router-outlet>
        </ion-tab>

        <ion-tab tab="about">
          <ion-router-outlet name="about"></ion-router-outlet>
        </ion-tab>

        {/* Tab bar */}
        <ion-tab-bar slot="bottom">
          <ion-tab-button tab="schedule" href="/app/tabs/(schedule:schedule)">
            <ion-icon name="calendar"></ion-icon>
            <ion-label>Schedule</ion-label>
          </ion-tab-button>

          <ion-tab-button tab="speakers" href="/app/tabs/(speakers:speakers)">
            <ion-icon name="person-circle"></ion-icon>
            <ion-label>Speakers</ion-label>
          </ion-tab-button>

          <ion-tab-button tab="map" href="/app/tabs/(map:map)">
            <ion-icon name="map"></ion-icon>
            <ion-label>Map</ion-label>
          </ion-tab-button>

          <ion-tab-button tab="about" href="/app/tabs/(about:about)">
            <ion-icon name="information-circle"></ion-icon>
            <ion-label>About</ion-label>
          </ion-tab-button>
        </ion-tab-bar>
      </ion-tabs>
    ];
  }
}
```
