/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.List;
import java.util.Map;
import weibo4j.Weibo;
import weibo4j.model.Geos;
import weibo4j.model.Poisition;
import weibo4j.model.PostParameter;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONObject;
import weibo4j.util.ArrayUtils;
import weibo4j.util.WeiboConfig;

public class Location
extends Weibo {
    private static final long serialVersionUID = -1725959237036370434L;

    public Location(String access_token) {
        this.access_token = access_token;
    }

    public JSONObject getMapImageByCenter(String centerCoordinate) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/base/get_map_image.json", new PostParameter[]{new PostParameter("center_coordinate", centerCoordinate)}, this.access_token).asJSONObject();
    }

    public JSONObject getMapImageByCity(String city) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/base/get_map_image.json", new PostParameter[]{new PostParameter("city", city)}, this.access_token).asJSONObject();
    }

    public JSONObject getMapImage(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/base/get_map_image.json", parList, this.access_token).asJSONObject();
    }

    public List<Geos> ipToGeo(String ip) throws WeiboException {
        return Geos.constructGeos(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/geo/ip_to_geo.json", new PostParameter[]{new PostParameter("ip", ip)}, this.access_token));
    }

    public List<Geos> addressToGeo(String address) throws WeiboException {
        return Geos.constructGeos(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/geo/address_to_geo.json", new PostParameter[]{new PostParameter("address", address)}, this.access_token));
    }

    public List<Geos> geoToAddress(String coordinate) throws WeiboException {
        return Geos.constructGeos(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/geo/geo_to_address.json", new PostParameter[]{new PostParameter("coordinate", coordinate)}, this.access_token));
    }

    public JSONObject gpsToOffset(String coordinate) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/geo/gps_to_offset.json", new PostParameter[]{new PostParameter("coordinate", coordinate)}, this.access_token).asJSONObject();
    }

    public JSONObject isDomestic(String coordinates) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/geo/is_domestic.json", new PostParameter[]{new PostParameter("coordinates", coordinates)}, this.access_token).asJSONObject();
    }

    public List<Poisition> searchPoisByLocationByQ(String q) throws WeiboException {
        return Poisition.constructPois(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_location.json", new PostParameter[]{new PostParameter("q", q)}, this.access_token));
    }

    public List<Poisition> searchPoisByLocationByCategory(String category) throws WeiboException {
        return Poisition.constructPois(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_location.json", new PostParameter[]{new PostParameter("category", category)}, this.access_token));
    }

    public List<Poisition> searchPoisByLocation(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Poisition.constructPois(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_location.json", parList, this.access_token));
    }

    public JSONObject searchPoisByGeoByQ(String q) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_geo.json", new PostParameter[]{new PostParameter("q", q)}, this.access_token).asJSONObject();
    }

    public JSONObject searchPoisByGeoByCoordinate(String q, String coordinate) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_geo.json", new PostParameter[]{new PostParameter("q", q), new PostParameter("coordinate", coordinate)}, this.access_token).asJSONObject();
    }

    public JSONObject searchPoisByGeoByCenname(String q, String cenname) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_geo.json", new PostParameter[]{new PostParameter("q", q), new PostParameter("cenname", cenname)}, this.access_token).asJSONObject();
    }

    public JSONObject searchPoisByGeo(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_geo.json", parList, this.access_token).asJSONObject();
    }

    public List<Poisition> searchPoisByAreaByQ(String q, String coordinates) throws WeiboException {
        return Poisition.constructPois(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_area.json", new PostParameter[]{new PostParameter("q", q), new PostParameter("coordinates", coordinates)}, this.access_token));
    }

    public List<Poisition> searchPoisByAreaByCategory(String category, String coordinates) throws WeiboException {
        return Poisition.constructPois(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_area.json", new PostParameter[]{new PostParameter("category", category), new PostParameter("coordinates", coordinates)}, this.access_token));
    }

    public List<Poisition> searchPoisByAreaByCategory(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Poisition.constructPois(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/search/by_area.json", parList, this.access_token));
    }

    public List<Poisition> showPoisBatch(String srcids) throws WeiboException {
        return Poisition.constructPois(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/show_batch.json", new PostParameter[]{new PostParameter("srcids", srcids)}, this.access_token));
    }

    public Poisition addPois(String srcid, String name, String address, String cityName, String category, String longitude, String latitude) throws WeiboException {
        return new Poisition(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/add.json", new PostParameter[]{new PostParameter("srcid", srcid), new PostParameter("name", name), new PostParameter("address", address), new PostParameter("city_name", cityName), new PostParameter("category", category), new PostParameter("latitude", latitude), new PostParameter("longitude", longitude)}, this.access_token));
    }

    public Poisition addPois(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Poisition(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/pois/add.json", parList, this.access_token));
    }

    public JSONObject getLocation(String json) throws WeiboException {
        return client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/mobile/get_location.json", new PostParameter[]{new PostParameter("json", json)}, this.access_token).asJSONObject();
    }

    public JSONObject searchDriveRouteByPid(String beginPid, String endPid) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/drive_route.json", new PostParameter[]{new PostParameter("begin_pid", beginPid), new PostParameter("end_pid", endPid)}, this.access_token).asJSONObject();
    }

    public JSONObject searchDriveRouteByCoordinate(String beginCoordinate, String endCoordinate) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/drive_route.json", new PostParameter[]{new PostParameter("begin_coordinate", beginCoordinate), new PostParameter("end_coordinate", endCoordinate)}, this.access_token).asJSONObject();
    }

    public JSONObject searchDriveRoute(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/drive_route.json", parList, this.access_token).asJSONObject();
    }

    public JSONObject searchBusRouteByPid(String beingPid, String endPid) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/bus_route.json", new PostParameter[]{new PostParameter("being_pid", beingPid), new PostParameter("end_pid", endPid)}, this.access_token).asJSONObject();
    }

    public JSONObject searchBusRouteByCoordinate(String beginCoordinate, String endCoordinate) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/bus_route.json", new PostParameter[]{new PostParameter("begin_coordinate", beginCoordinate), new PostParameter("end_coordinate", endCoordinate)}, this.access_token).asJSONObject();
    }

    public JSONObject searchBusRoute(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/bus_route.json", parList, this.access_token).asJSONObject();
    }

    public JSONObject searchBusLine(String q) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/bus_line.json", new PostParameter[]{new PostParameter("q", q)}, this.access_token).asJSONObject();
    }

    public JSONObject searchBusLine(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/bus_line.json", parList, this.access_token).asJSONObject();
    }

    public JSONObject searchBusStation(String q) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/bus_station.json", new PostParameter[]{new PostParameter("q", q)}, this.access_token).asJSONObject();
    }

    public JSONObject searchBusStation(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "location/line/bus_station.json", parList, this.access_token).asJSONObject();
    }
}

