/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.List;
import java.util.Map;
import weibo4j.Weibo;
import weibo4j.http.ImageItem;
import weibo4j.model.Emotion;
import weibo4j.model.FriendsTimelineIds;
import weibo4j.model.MentionsIds;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.RepostTimelineIds;
import weibo4j.model.Status;
import weibo4j.model.StatusWapper;
import weibo4j.model.UserTimelineIds;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONObject;
import weibo4j.util.ArrayUtils;
import weibo4j.util.WeiboConfig;

public class Timeline
extends Weibo {
    private static final long serialVersionUID = 6235150828015082132L;

    public Timeline(String access_token) {
        this.access_token = access_token;
    }

    public StatusWapper getPublicTimeline() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/public_timeline.json", this.access_token));
    }

    public StatusWapper getPublicTimeline(int count, int baseApp) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/public_timeline.json", new PostParameter[]{new PostParameter("count", count), new PostParameter("base_app", baseApp)}, this.access_token));
    }

    public StatusWapper getFriendsTimeline() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline.json", this.access_token));
    }

    public StatusWapper getFriendsTimeline(Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline.json", new PostParameter[]{new PostParameter("base_app", baseAPP.toString()), new PostParameter("feature", feature.toString())}, paging, this.access_token));
    }

    public StatusWapper getFriendsTimeline(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline.json", parList, this.access_token));
    }

    public FriendsTimelineIds getFriendsTimelineIds() throws WeiboException {
        return new FriendsTimelineIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline/ids.json", this.access_token));
    }

    public JSONObject getFriendsTimelineIds(Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline/ids.json", new PostParameter[]{new PostParameter("base_app", baseAPP.toString()), new PostParameter("feature", feature.toString())}, paging, this.access_token).asJSONObject();
    }

    public JSONObject getFriendsTimelineIds(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline/ids.json", parList, this.access_token).asJSONObject();
    }

    public StatusWapper getHomeTimeline() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/home_timeline.json", this.access_token));
    }

    public StatusWapper getHomeTimeline(Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/home_timeline.json", new PostParameter[]{new PostParameter("base_app", baseAPP.toString()), new PostParameter("feature", feature.toString())}, paging, this.access_token));
    }

    public StatusWapper getHomeTimeline(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/home_timeline.json", parList, this.access_token));
    }

    public StatusWapper getUserTimeline() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", this.access_token));
    }

    public StatusWapper getUserTimelineByUid(String uid) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public StatusWapper getUserTimelineByName(String screen_name) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token));
    }

    public StatusWapper getUserTimelineByUid(String uid, Paging page, Integer base_app, Integer feature) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("base_app", base_app.toString()), new PostParameter("feature", feature.toString())}, page, this.access_token));
    }

    public StatusWapper getUserTimelineByName(String screen_name, Paging page, Integer base_app, Integer feature) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("base_app", base_app.toString()), new PostParameter("feature", feature.toString())}, page, this.access_token));
    }

    public StatusWapper getUserTimeline(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", parList, this.access_token));
    }

    public UserTimelineIds getUserTimelineIdsByUid(String uid) throws WeiboException {
        return new UserTimelineIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline/ids.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public JSONObject getUserTimelineIdsByName(String screen_name) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token).asJSONObject();
    }

    public JSONObject getUserTimelineIds(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline/ids.json", parList, this.access_token).asJSONObject();
    }

    public StatusWapper getRepostTimeline(String id) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public StatusWapper getRepostTimeline(String id, Paging page) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline.json", new PostParameter[]{new PostParameter("id", id)}, page, this.access_token));
    }

    public StatusWapper getRepostTimeline(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline.json", parList, this.access_token));
    }

    public RepostTimelineIds getRepostTimelineIds(String id) throws WeiboException {
        return new RepostTimelineIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline/ids.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public RepostTimelineIds getRepostTimelineIds(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new RepostTimelineIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline/ids.json", parList, this.access_token));
    }

    public StatusWapper getRepostByMe() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_by_me.json", this.access_token));
    }

    public StatusWapper getRepostByMe(Paging page) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_by_me.json", null, page, this.access_token));
    }

    public StatusWapper getMentions() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions.json", this.access_token));
    }

    public StatusWapper getMentions(Paging page, Integer filter_by_author, Integer filter_by_source, Integer filter_by_type) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions.json", new PostParameter[]{new PostParameter("filter_by_author", filter_by_author.toString()), new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_type", filter_by_type.toString())}, page, this.access_token));
    }

    public StatusWapper getMentions(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions.json", parList, this.access_token));
    }

    public MentionsIds getMentionsIds() throws WeiboException {
        return new MentionsIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions/ids.json", this.access_token));
    }

    public JSONObject getMentionsIds(Paging page, Integer filter_by_author, Integer filter_by_source, Integer filter_by_type) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions/ids.json", new PostParameter[]{new PostParameter("filter_by_author", filter_by_author.toString()), new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_type", filter_by_type.toString())}, page, this.access_token).asJSONObject();
    }

    public JSONObject getMentionsIds(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions/ids.json", parList, this.access_token).asJSONObject();
    }

    public StatusWapper getBilateralTimeline() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/bilateral_timeline.json", this.access_token));
    }

    public StatusWapper getBilateralTimeline(Integer base_app, Integer feature) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/bilateral_timeline.json", new PostParameter[]{new PostParameter("base_app", base_app), new PostParameter("feature", feature)}, this.access_token));
    }

    public StatusWapper getBilateralTimeline(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/bilateral_timeline.json", parList, this.access_token));
    }

    public Status showStatus(String id) throws WeiboException {
        return new Status(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/show.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public JSONObject queryMid(Integer type, String id) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/querymid.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("type", type.toString())}, this.access_token).asJSONObject();
    }

    public JSONObject queryMid(Integer type, String id, int is_batch) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/querymid.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("type", type.toString()), new PostParameter("is_batch", is_batch)}, this.access_token).asJSONObject();
    }

    public JSONObject queryId(String mid, Integer type, int isBase62) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/queryid.json", new PostParameter[]{new PostParameter("mid", mid), new PostParameter("type", type.toString()), new PostParameter("isBase62", isBase62)}, this.access_token).asJSONObject();
    }

    public JSONObject queryId(String mid, Integer type, Integer isBatch, Integer isBase62) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/queryid.json", new PostParameter[]{new PostParameter("mid", mid), new PostParameter("type", type.toString()), new PostParameter("is_batch", isBatch.toString()), new PostParameter("isBase62", isBase62.toString())}, this.access_token).asJSONObject();
    }

    public JSONObject queryId(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/queryid.json", parList, this.access_token).asJSONObject();
    }

    public Status repost(String id) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public Status repost(String id, String status, Integer is_comment) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("status", status), new PostParameter("is_comment", is_comment.toString())}, this.access_token));
    }

    public Status repost(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost.json", parList, this.access_token));
    }

    public Status destroy(String id) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/destroy.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public Status updateStatus(String status) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status)}, this.access_token));
    }

    public Status updateStatus(String status, Float lat, Float longs, String annotations) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", lat.toString()), new PostParameter("long", longs.toString()), new PostParameter("annotations", annotations)}, this.access_token));
    }

    public Status updateStatus(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/update.json", parList, this.access_token));
    }

    public Status uploadStatus(String status, ImageItem item) throws WeiboException {
        return new Status(client.multPartURL(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status)}, item, this.access_token));
    }

    public Status uploadStatus(String status, ImageItem item, Float lat, Float longs) throws WeiboException {
        return new Status(client.multPartURL(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", lat.toString()), new PostParameter("long", longs.toString())}, item, this.access_token));
    }

    public Status uploadStatus(Map<String, String> map, ImageItem item) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Status(client.multPartURL(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/upload.json", parList, item, this.access_token));
    }

    public List<Emotion> getEmotions() throws WeiboException {
        return Emotion.constructEmotions(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "emotions.json", this.access_token));
    }

    public List<Emotion> getEmotions(String type, String language) throws WeiboException {
        return Emotion.constructEmotions(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "emotions.json", new PostParameter[]{new PostParameter("type", type), new PostParameter("language", language)}, this.access_token));
    }

    public JSONArray getStatusesCount(String ids) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/count.json", new PostParameter[]{new PostParameter("ids", ids)}, this.access_token).asJSONArray();
    }
}

