/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Emotion
extends WeiboResponse {
    private static final long serialVersionUID = -4096813631691846494L;
    private String phrase;
    private String type;
    private String url;
    private boolean hot;
    private boolean common;
    private String value;
    private String category;
    private String picid;
    private String icon;

    public Emotion(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.phrase = json.getString("phrase");
            this.type = json.getString("type");
            this.url = json.getString("url");
            this.hot = json.getBoolean("hot");
            this.category = json.getString("category");
            this.common = json.getBoolean("common");
            this.value = json.getString("value");
            this.picid = json.getString("picid");
            this.icon = json.getString("icon");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Emotion(JSONObject json) throws WeiboException {
        try {
            this.phrase = json.getString("phrase");
            this.type = json.getString("type");
            this.url = json.getString("url");
            this.hot = json.getBoolean("hot");
            this.category = json.getString("category");
            this.common = json.getBoolean("common");
            this.value = json.getString("value");
            this.picid = json.getString("picid");
            this.icon = json.getString("icon");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public static List<Emotion> constructEmotions(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Emotion> emotions = new ArrayList<Emotion>(size);
            int i = 0;
            while (i < size) {
                emotions.add(new Emotion(list.getJSONObject(i)));
                ++i;
            }
            return emotions;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public Emotion() {
    }

    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean isHot() {
        return this.hot;
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    public boolean isCommon() {
        return this.common;
    }

    public void setCommon(boolean common) {
        this.common = common;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPicid() {
        return this.picid;
    }

    public void setPicid(String picid) {
        this.picid = picid;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String toString() {
        return "Emotion [phrase=" + this.phrase + ", type=" + this.type + ", url=" + this.url + ", hot=" + this.hot + ", common=" + this.common + ", value=" + this.value + ", category=" + this.category + ", picid=" + this.picid + ", icon=" + this.icon + "]";
    }
}

