/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.FavoritesTag;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class FavoritesIds
extends WeiboResponse {
    private static final long serialVersionUID = -2969906105821204489L;
    private Date favoritedTime;
    private String statusId;
    private List<FavoritesTag> tags;
    private static long totalNumber;

    public FavoritesIds(Response res) throws WeiboException {
        super(res);
        JSONObject json = null;
        try {
            json = res.asJSONObject();
            this.favoritedTime = FavoritesIds.parseDate(json.getString("favorited_time"), "EEE MMM dd HH:mm:ss z yyyy");
            this.statusId = json.getString("status");
            if (!json.isNull("tags")) {
                JSONArray list = json.getJSONArray("tags");
                int size = list.length();
                ArrayList<FavoritesTag> tag = new ArrayList<FavoritesTag>(size);
                int i = 0;
                while (i < size) {
                    tag.add(new FavoritesTag(list.getJSONObject(i)));
                    ++i;
                }
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    FavoritesIds(JSONObject json) throws WeiboException, JSONException {
        this.favoritedTime = FavoritesIds.parseDate(json.getString("favorited_time"), "EEE MMM dd HH:mm:ss z yyyy");
        if (!json.isNull("status")) {
            this.statusId = json.getString("status");
        }
        if (!json.isNull("tags")) {
            JSONArray list = json.getJSONArray("tags");
            int size = list.length();
            this.tags = new ArrayList<FavoritesTag>(size);
            int i = 0;
            while (i < size) {
                this.tags.add(new FavoritesTag(list.getJSONObject(i)));
                ++i;
            }
        }
    }

    public static List<FavoritesIds> constructFavoritesIds(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("favorites");
            int size = list.length();
            ArrayList<FavoritesIds> favoritesIds = new ArrayList<FavoritesIds>(size);
            int i = 0;
            while (i < size) {
                favoritesIds.add(new FavoritesIds(list.getJSONObject(i)));
                ++i;
            }
            totalNumber = res.asJSONObject().getLong("total_number");
            return favoritesIds;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public Date getFavoritedTime() {
        return this.favoritedTime;
    }

    public void setFavoritedTime(Date favoritedTime) {
        this.favoritedTime = favoritedTime;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public static long getTotalNumber() {
        return totalNumber;
    }

    public static void setTotalNumber(long totalNumber) {
        FavoritesIds.totalNumber = totalNumber;
    }

    public String toString() {
        return "Favorites [favorited_time=" + this.favoritedTime + ", statusId=" + this.statusId + ", FavoritesTag=" + (this.tags == null ? "null" : this.tags.toString()) + ", total_number = " + totalNumber + "]";
    }
}

