/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Geos
extends WeiboResponse {
    private static final long serialVersionUID = -3147781298339233908L;
    private String longitude;
    private String latitude;
    private String city;
    private String province;
    private String cityName;
    private String provinceName;
    private String address;
    private String pinyin;
    private String more;

    public Geos(Response res) throws WeiboException {
        super(res);
        JSONObject json = null;
        try {
            json = res.asJSONObject();
            this.longitude = json.getString("longitude");
            this.latitude = json.getString("latitude");
            this.city = json.getString("city");
            this.province = json.getString("province");
            this.cityName = json.getString("city_name");
            this.provinceName = json.getString("province_name");
            this.address = json.getString("address");
            this.pinyin = json.getString("pinyin");
            this.more = json.getString("more");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Geos(JSONObject json) throws WeiboException {
        try {
            this.longitude = json.getString("longitude");
            this.latitude = json.getString("latitude");
            this.city = json.getString("city");
            this.province = json.getString("province");
            this.cityName = json.getString("city_name");
            this.provinceName = json.getString("province_name");
            this.address = json.getString("address");
            this.pinyin = json.getString("pinyin");
            this.more = json.getString("more");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public static List<Geos> constructGeos(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("geos");
            int size = list.length();
            ArrayList<Geos> geos = new ArrayList<Geos>(size);
            int i = 0;
            while (i < size) {
                geos.add(new Geos(list.getJSONObject(i)));
                ++i;
            }
            return geos;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPinyin() {
        return this.pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public String getMore() {
        return this.more;
    }

    public void setMore(String more) {
        this.more = more;
    }

    public String toString() {
        return "Geos [longitude = " + this.longitude + ", latitude = " + this.latitude + ", city = " + this.city + ", province = " + this.province + ", city_name = " + this.cityName + ", province_name = " + this.provinceName + ", address = " + this.address + ", pinyin = " + this.pinyin + ", more = " + this.more + "]";
    }
}

