/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Poisition
extends WeiboResponse {
    private static final long serialVersionUID = -6156515630521071392L;
    private String srcid;
    private String longitude;
    private String latitude;
    private String name;
    private String cityName;
    private String address;
    private String telephone;
    private String category;
    private String description;
    private String intro;
    private String tags;
    private String url;
    private String traffic;
    private String deal;
    private String pid;
    private static long totalNumber;
    private static String coordinates;

    public Poisition(Response res) throws WeiboException {
        super(res);
        JSONObject json = null;
        try {
            json = res.asJSONObject();
            this.srcid = json.getString("srcid");
            this.longitude = json.getString("longitude");
            this.latitude = json.getString("latitude");
            this.name = json.getString("name");
            this.cityName = json.getString("city_name");
            this.address = json.getString("address");
            this.telephone = json.getString("telephone");
            this.category = json.getString("category");
            this.description = json.getString("description");
            this.intro = json.getString("intro");
            this.tags = json.getString("tags");
            this.url = json.getString("url");
            this.traffic = json.getString("traffic");
            this.deal = json.getString("deal");
            this.pid = json.getString("pid");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Poisition(JSONObject json) throws WeiboException {
        try {
            this.srcid = json.getString("srcid");
            this.longitude = json.getString("longitude");
            this.latitude = json.getString("latitude");
            this.name = json.getString("name");
            this.cityName = json.getString("city_name");
            this.address = json.getString("address");
            this.telephone = json.getString("telephone");
            this.category = json.getString("category");
            this.description = json.getString("description");
            this.intro = json.getString("intro");
            this.tags = json.getString("tags");
            this.url = json.getString("url");
            this.traffic = json.getString("traffic");
            this.deal = json.getString("deal");
            this.pid = json.getString("pid");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public static List<Poisition> constructPois(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("pois");
            int size = list.length();
            ArrayList<Poisition> pois = new ArrayList<Poisition>(size);
            int i = 0;
            while (i < size) {
                pois.add(new Poisition(list.getJSONObject(i)));
                ++i;
            }
            totalNumber = res.asJSONObject().getLong("total_number");
            coordinates = res.asJSONObject().getString("coordinates");
            return pois;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public String getSrcid() {
        return this.srcid;
    }

    public void setSrcid(String srcid) {
        this.srcid = srcid;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIntro() {
        return this.intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTraffic() {
        return this.traffic;
    }

    public void setTraffic(String traffic) {
        this.traffic = traffic;
    }

    public String getDeal() {
        return this.deal;
    }

    public void setDeal(String deal) {
        this.deal = deal;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public static long getTotalNumber() {
        return totalNumber;
    }

    public static void setTotalNumber(long totalNumber) {
        Poisition.totalNumber = totalNumber;
    }

    public static String getCoordinates() {
        return coordinates;
    }

    public static void setCoordinates(String coordinates) {
        Poisition.coordinates = coordinates;
    }

    public String toString() {
        return "Pois [coordinates = " + coordinates + ", srcid = " + this.srcid + ", longitude = " + this.longitude + ", latitude = " + this.latitude + ", name = " + this.name + ", city_name = " + this.cityName + ", address = " + this.address + ", telephone = " + this.telephone + ", category = " + this.category + ", description = " + this.description + ", intro = " + this.intro + ", tags = " + this.tags + ", url = " + this.url + ", traffic = " + this.traffic + ", deal = " + this.deal + ", pid = " + this.pid + ", totalNumber = " + totalNumber + "]";
    }
}

