/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class PostParameter
implements Serializable {
    String name;
    String value;
    private File file = null;
    private static final long serialVersionUID = -8708108746980739212L;
    private static final String JPEG = "image/jpeg";
    private static final String GIF = "image/gif";
    private static final String PNG = "image/png";
    private static final String OCTET = "application/octet-stream";

    public PostParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public PostParameter(String name, long value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public PostParameter(String name, double value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public PostParameter(String name, int value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public PostParameter(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        String extensions = this.file.getName();
        int index = extensions.lastIndexOf(".");
        String contentType = -1 == index ? OCTET : ((extensions = extensions.substring(extensions.lastIndexOf(".") + 1).toLowerCase()).length() == 3 ? ("gif".equals(extensions) ? GIF : ("png".equals(extensions) ? PNG : ("jpg".equals(extensions) ? JPEG : OCTET))) : (extensions.length() == 4 ? ("jpeg".equals(extensions) ? JPEG : OCTET) : OCTET));
        return contentType;
    }

    public static boolean containsFile(PostParameter[] params) {
        boolean containsFile = false;
        if (params == null) {
            return false;
        }
        PostParameter[] postParameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            PostParameter param = postParameterArray[n2];
            if (param.isFile()) {
                containsFile = true;
                break;
            }
            ++n2;
        }
        return containsFile;
    }

    static boolean containsFile(List<PostParameter> params) {
        boolean containsFile = false;
        for (PostParameter param : params) {
            if (!param.isFile()) continue;
            containsFile = true;
            break;
        }
        return containsFile;
    }

    public static PostParameter[] getParameterArray(String name, String value) {
        return new PostParameter[]{new PostParameter(name, value)};
    }

    public static PostParameter[] getParameterArray(String name, int value) {
        return PostParameter.getParameterArray(name, String.valueOf(value));
    }

    public static PostParameter[] getParameterArray(String name1, String value1, String name2, String value2) {
        return new PostParameter[]{new PostParameter(name1, value1), new PostParameter(name2, value2)};
    }

    public static PostParameter[] getParameterArray(String name1, int value1, String name2, int value2) {
        return PostParameter.getParameterArray(name1, String.valueOf(value1), name2, String.valueOf(value2));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof PostParameter) {
            PostParameter that = (PostParameter)obj;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
                return false;
            }
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return "PostParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", file=" + this.file + '}';
    }

    public int compareTo(Object o) {
        PostParameter that = (PostParameter)o;
        int compared = this.name.compareTo(that.name);
        if (compared == 0) {
            compared = this.value.compareTo(that.value);
        }
        return compared;
    }

    public static String encodeParameters(PostParameter[] httpParams) {
        if (httpParams == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < httpParams.length) {
            if (httpParams[j].isFile()) {
                throw new IllegalArgumentException("parameter [" + httpParams[j].name + "]should be text");
            }
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(URLEncoder.encode(httpParams[j].name, "UTF-8")).append("=").append(URLEncoder.encode(httpParams[j].value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++j;
        }
        return buf.toString();
    }
}

