/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class RepostTimelineIds
extends WeiboResponse {
    private static final long serialVersionUID = -218980626251113794L;
    private long nextCursor;
    private long previousCursor;
    private long totalNumber;
    private long interval;
    private List<String> statusesIds;
    private boolean hasvisible;

    public RepostTimelineIds(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.nextCursor = json.getLong("next_cursor");
            this.previousCursor = json.getLong("previous_cursor");
            this.totalNumber = json.getLong("total_number");
            this.hasvisible = json.getBoolean("hasvisible");
            this.interval = json.getLong("interval");
            JSONArray list = json.getJSONArray("statuses");
            int size = list.length();
            this.statusesIds = new ArrayList<String>(size);
            int i = 0;
            while (i < size) {
                this.statusesIds.add(list.getString(i));
                ++i;
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public RepostTimelineIds(JSONObject json) throws WeiboException {
        try {
            this.nextCursor = json.getLong("next_cursor");
            this.previousCursor = json.getLong("previous_cursor");
            this.totalNumber = json.getLong("total_number");
            this.hasvisible = json.getBoolean("hasvisible");
            this.interval = json.getLong("interval");
            JSONArray list = json.getJSONArray("statuses");
            int size = list.length();
            this.statusesIds = new ArrayList<String>(size);
            int i = 0;
            while (i < size) {
                this.statusesIds.add(list.getString(i));
                ++i;
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(long nextCursor) {
        this.nextCursor = nextCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public void setPreviousCursor(long previousCursor) {
        this.previousCursor = previousCursor;
    }

    public long getTotalNumber() {
        return this.totalNumber;
    }

    public void setTotalNumber(long totalNumber) {
        this.totalNumber = totalNumber;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public List<String> getStatusesIds() {
        return this.statusesIds;
    }

    public void setStatusesIds(List<String> statusesIds) {
        this.statusesIds = statusesIds;
    }

    public boolean isHasvisible() {
        return this.hasvisible;
    }

    public void setHasvisible(boolean hasvisible) {
        this.hasvisible = hasvisible;
    }

    public String toString() {
        return "RepostTimelineIds [next_cursor=" + this.nextCursor + ", previous_cursor=" + this.previousCursor + ", interval=" + this.interval + ", hasvisible=" + this.hasvisible + ", statusesIds=" + this.statusesIds + ", total_number = " + this.totalNumber + "]";
    }
}

