/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class SchoolSearch
extends WeiboResponse {
    private static final long serialVersionUID = 4059782919675941016L;
    private String schoolName;
    private String location;
    private long id;
    private long type;

    public SchoolSearch(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getInt("id");
            this.location = json.getString("location");
            this.type = json.getLong("type");
            this.schoolName = json.getString("school_name");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public SchoolSearch(JSONObject json) throws WeiboException {
        try {
            this.id = json.getInt("id");
            this.location = json.getString("location");
            this.type = json.getLong("type");
            this.schoolName = json.getString("school_name");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public static List<SchoolSearch> constructSchoolSearch(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<SchoolSearch> schools = new ArrayList<SchoolSearch>(size);
            int i = 0;
            while (i < size) {
                schools.add(new SchoolSearch(list.getJSONObject(i)));
                ++i;
            }
            return schools;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public String getSchoolName() {
        return this.schoolName;
    }

    public void setSchoolName(String schoolName) {
        this.schoolName = schoolName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getType() {
        return this.type;
    }

    public void setType(long type) {
        this.type = type;
    }

    public String toString() {
        return "SchoolSearch [id=" + this.id + ",school_name=" + this.schoolName + ",location" + this.location + ", type=" + this.type + "]";
    }
}

