/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class UserCounts
extends WeiboResponse {
    private static final long serialVersionUID = -2841255612083504764L;
    private long id;
    private long followersCount;
    private long friendsCount;
    private long statusesCount;
    private long privateFriendsCount;

    public UserCounts(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getLong("id");
            this.followersCount = json.getLong("followers_count");
            this.friendsCount = json.getLong("friends_count");
            this.statusesCount = json.getLong("statuses_count");
            this.privateFriendsCount = json.getLong("private_friends_count");
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public UserCounts(JSONObject json) throws WeiboException {
        try {
            this.id = json.getLong("id");
            this.followersCount = json.getLong("followers_count");
            this.friendsCount = json.getLong("friends_count");
            this.statusesCount = json.getLong("statuses_count");
            this.privateFriendsCount = json.getLong("private_friends_count");
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public static List<UserCounts> constructUserCount(Response res) throws WeiboException {
        try {
            JSONArray json = res.asJSONArray();
            int size = json.length();
            ArrayList<UserCounts> list = new ArrayList<UserCounts>(size);
            int i = 0;
            while (i < size) {
                list.add(new UserCounts(json.getJSONObject(i)));
                ++i;
            }
            return list;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getFollowersCount() {
        return this.followersCount;
    }

    public void setFollowersCount(long followersCount) {
        this.followersCount = followersCount;
    }

    public long getFriendsCount() {
        return this.friendsCount;
    }

    public void setFriendsCount(long friendsCount) {
        this.friendsCount = friendsCount;
    }

    public long getStatusesCount() {
        return this.statusesCount;
    }

    public void setStatusesCount(long statusesCount) {
        this.statusesCount = statusesCount;
    }

    public long getPrivateFriendsCount() {
        return this.privateFriendsCount;
    }

    public void setPrivateFriendsCount(long privateFriendsCount) {
        this.privateFriendsCount = privateFriendsCount;
    }

    public String toString() {
        return "UserCount [id=" + this.id + ", friends_count=" + this.friendsCount + ", followers_count=" + this.followersCount + ", statuses_count=" + this.statusesCount + ", private_friends_count=" + this.privateFriendsCount + "]";
    }
}

