package com.jspxcms.core.web.back;

import static com.jspxcms.core.constant.Constants.DELETE_SUCCESS;
import static com.jspxcms.core.constant.Constants.MESSAGE;
import static com.jspxcms.core.constant.Constants.PAGE_SIZE;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.jspxcms.common.web.Servlets;
import com.jspxcms.core.constant.Constants;
import com.jspxcms.core.domain.Notification;
import com.jspxcms.core.domain.User;
import com.jspxcms.core.service.NotificationService;
import com.jspxcms.core.support.Context;

@Controller
@RequestMapping("/core/notification")
public class NotificationController {
	private static final Logger logger = LoggerFactory.getLogger(NotificationController.class);

	@GetMapping("count.do")
	@ResponseBody
	public String countNotification() {
		User user = Context.getCurrentUser();
		int count = service.countByReceiverId(user.getId());
		return String.valueOf(count);
	}

	@RequiresPermissions("core:notification:list")
	@GetMapping("list.do")
	public String list(@PageableDefault(sort = "id", direction = Direction.DESC, size = PAGE_SIZE) Pageable pageable,
			HttpServletRequest request, org.springframework.ui.Model modelMap) {
		Map<String, String[]> params = Servlets.getParamValuesMap(request, Constants.SEARCH_PREFIX);
		Page<Notification> pagedList = service.findAll(null, params, pageable);
		modelMap.addAttribute("pagedList", pagedList);
		return "core/notification/notification_list";
	}

	@RequiresPermissions("core:notification:delete")
	@RequestMapping("delete.do")
	public String delete(Integer[] ids, RedirectAttributes ra) {
		for (Integer id : ids) {
			Notification bean = service.delete(id);
			logger.info("delete Notification, content={}.", bean.getContent());
		}
		ra.addFlashAttribute(MESSAGE, DELETE_SUCCESS);
		return "redirect:list.do";
	}

	@ModelAttribute("bean")
	public Notification preloadBean(@RequestParam(required = false) Integer oid) {
		return oid != null ? service.get(oid) : null;
	}

	@Autowired
	private NotificationService service;
}
