package com.jspxcms.core.web.fore;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import com.jspxcms.common.web.Servlets;
import com.jspxcms.core.constant.Constants;
import com.jspxcms.core.domain.Site;
import com.jspxcms.core.support.Context;
import com.jspxcms.core.support.ForeContext;
import com.jspxcms.core.support.Response;
import com.jspxcms.core.support.SiteResolver;

/**
 * AppController
 *
 * @author liufang
 */
@Controller
public class AppController {

    @GetMapping("/app")
    private String app(Integer page, HttpServletRequest request, HttpServletResponse response, org.springframework.ui.Model modelMap) {
        return app(null, page, request, response, modelMap);
    }

    @GetMapping(Constants.SITE_PREFIX_PATH + "/app")
    private String app(@PathVariable String siteNumber, Integer page, HttpServletRequest request, HttpServletResponse response, org.springframework.ui.Model modelMap) {
        siteResolver.resolveSite(siteNumber);
        Site site = Context.getCurrentSite();
        Response resp = new Response(request, response, modelMap);
        String template = Servlets.getParam(request, "template");
        if (StringUtils.isBlank(template)) {
            return resp.badRequest("parameter 'template' is required.");
        }
        template = "app_" + template + ".html";

        Map<String, Object> data = modelMap.asMap();
        ForeContext.setData(data, request);
        ForeContext.setPage(data, page);
        return site.getTemplate(template);
    }

    @Autowired
    private SiteResolver siteResolver;
}
