<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="fnx" uri="http://java.sun.com/jsp/jstl/functionsx" %>
<%@ taglib prefix="s" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="f" uri="http://www.jspxcms.com/tags/form" %>
<%@ taglib prefix="shiro" uri="http://shiro.apache.org/tags" %>
<%@ taglib prefix="tags" tagdir="/WEB-INF/tags" %>
<!DOCTYPE html>
<html>
<head>
    <jsp:include page="/WEB-INF/views/head.jsp"/>
    <script type="text/javascript">
        $(function () {

            $("#sortHead").headSort();
            <shiro:hasPermission name="core:homepage:mail_inbox:show">
            $("#pagedTable tbody tr").dblclick(function (eventObj) {
                var nodeName = eventObj.target.nodeName.toLowerCase();
                if (nodeName != "input" && nodeName != "select" && nodeName != "textarea") {
                    location.href = $("#show_opt_" + $(this).attr("beanid")).attr('href');
                }
            });
            </shiro:hasPermission>
        });
        function confirmDelete() {
            return confirm("<s:message code='confirmDelete'/>");
        }
        function optSingle(opt) {
            if (Cms.checkeds("ids") == 0) {
                alert("<s:message code='pleaseSelectRecord'/>");
                return false;
            }
            if (Cms.checkeds("ids") > 1) {
                alert("<s:message code='pleaseSelectOne'/>");
                return false;
            }
            var id = $("input[name='ids']:checkbox:checked").val();
            location.href = $(opt + id).attr("href");
        }
        function optMulti(form, action, msg) {
            if (Cms.checkeds("ids") == 0) {
                alert("<s:message code='pleaseSelectRecord'/>");
                return false;
            }
            if (msg && !confirm(msg)) {
                return false;
            }
            form.action = action;
            form.submit();
            return true;
        }
        function optDelete(form) {
            if (Cms.checkeds("ids") == 0) {
                alert("<s:message code='pleaseSelectRecord'/>");
                return false;
            }
            if (!confirmDelete()) {
                return false;
            }
            form.action = 'mail_inbox_delete.do';
            form.submit();
            return true;
        }
    </script>
</head>
<body class="skin-blue content-body">
<jsp:include page="/WEB-INF/views/commons/show_message.jsp"/>
<div class="content-header">
    <h1><s:message code="homepage.mailInbox"/> - <s:message code="list"/>
        <small>(<s:message code="totalElements" arguments="${pagedList.totalElements}"/>)</small>
    </h1>
</div>

<div class="content">
    <div class="box box-primary">
        <div class="box-body table-responsive">
            <form action="mail_inbox_list.do" method="get" class="form-inline ls-search">
                <div class="form-group">
                    <label for="search_CONTAIN_mailText.subject"><s:message code="mail.content"/></label>
                    <input class="form-control input-sm" type="text" id="search_CONTAIN_mailText.subject" name="search_CONTAIN_mailText.subject" value="${requestScope['search_CONTAIN_mailText.subject'][0]}" style="width:150px;"/></label>
                </div>
                <button class="btn btn-default btn-sm" type="submit"><s:message code="search"/></button>
            </form>
            <form method="post">
                <tags:search_params/>
                <div class="btn-toolbar ls-btn-bar">
                    <div class="btn-group">
                        <shiro:hasPermission name="core:homepage:mail_inbox:show">
                            <button class="btn btn-default" type="button" onclick="return optSingle('#show_opt_');"><s:message code="show"/></button>
                        </shiro:hasPermission>
                        <shiro:hasPermission name="core:homepage:mail_inbox:delete">
                            <button class="btn btn-default" type="button" onclick="return optDelete(this.form);"><s:message code="delete"/></button>
                        </shiro:hasPermission>
                    </div>
                </div>
                <table id="pagedTable" class="table table-condensed table-bordered table-hover ls-tb">
                    <thead id="sortHead" pagesort="<c:out value='${page_sort[0]}' />" pagedir="${page_sort_dir[0]}" pageurl="mail_inbox_list.do?page_sort={0}&page_sort_dir={1}&${searchstringnosort}">
                    <tr class="ls_table_th">
                        <th width="25"><input type="checkbox" onclick="Cms.check('ids',this.checked);"/></th>
                        <th width="90"><s:message code="operate"/></th>
                        <th width="30" class="ls-th-sort"><span class="ls-sort" pagesort="id">ID</span></th>
                        <th width="160" class="ls-th-sort"><span class="ls-sort" pagesort="receiveTime"><s:message code="mail.receiveTime"/></span></th>
                        <th><s:message code="mail.content"/></th>
                        <th width="100" class="ls-th-sort"><span class="ls-sort" pagesort="unread"><s:message code="mail.unread"/></span></th>
                    </tr>
                    </thead>
                    <tbody>
                    <c:forEach var="bean" varStatus="status" items="${pagedList.content}">
                        <tr beanid="${bean.id}">
                            <td><input type="checkbox" name="ids" value="${bean.id}"/></td>
                            <td align="center">
                                <shiro:hasPermission name="core:homepage:mail_inbox:show">
                                    <a id="show_opt_${bean.id}" href="mail_inbox_show.do?id=${bean.id}&position=${pagedList.number*pagedList.size+status.index}&${searchstring}" class="ls-opt"><s:message code="show"/></a>
                                </shiro:hasPermission>
                                <shiro:hasPermission name="core:homepage:mail_inbox:delete">
                                    <a href="mail_inbox_delete.do?ids=${bean.id}&${searchstring}" onclick="return confirmDelete();" class="ls-opt"><s:message code="delete"/></a>
                                </shiro:hasPermission>
                            </td>
                            <td><c:out value="${bean.id}"/></td>
                            <td align="center"><fmt:formatDate value="${bean.receiveTime}" pattern="yyyy-MM-dd HH:mm:ss"/></td>
                            <td>
                                <div><strong><c:out value="${fnx:substringx_sis(bean.subject,50,'...')}"/></strong></div>
                                <div><c:out value="${fnx:substringx_sis(bean.text,50,'...')}"/></div>
                            </td>
                            <td align="center"><c:choose><c:when test="${bean.unread}"><strong style="color:red;"><s:message code="mail.unread.1"/></strong></c:when><c:otherwise><s:message code="mail.unread.0"/></c:otherwise></c:choose></td>
                        </tr>
                    </c:forEach>
                    </tbody>
                </table>
                <c:if test="${fn:length(pagedList.content) le 0}">
                    <div class="ls-norecord"><s:message code="recordNotFound"/></div>
                </c:if>
            </form>
            <form action="mail_inbox_list.do" method="get" class="ls-page">
                <tags:search_params excludePage="true"/>
                <tags:pagination pagedList="${pagedList}"/>
            </form>
        </div>
    </div>
</div>


</body>
</html>