<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="fnx" uri="http://java.sun.com/jsp/jstl/functionsx" %>
<%@ taglib prefix="s" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="f" uri="http://www.jspxcms.com/tags/form" %>
<%@ taglib prefix="shiro" uri="http://shiro.apache.org/tags" %>
<%@ taglib prefix="tags" tagdir="/WEB-INF/tags" %>
<!DOCTYPE html>
<html>
<head>
    <jsp:include page="/WEB-INF/views/head.jsp" />
    <script type="text/javascript">
        $(function () {
            $("#sortHead").headSort();
            <shiro:hasPermission name="core:role:edit">
            $("#pagedTable tbody tr").dblclick(function (eventObj) {
                var nodeName = eventObj.target.nodeName.toLowerCase();
                if (nodeName != "input" && nodeName != "select" && nodeName != "textarea") {
                    location.href = $("#edit_opt_" + $(this).attr("beanid")).attr('href');
                }
            });
            </shiro:hasPermission>
        });

        function confirmDelete() {
            return confirm("<s:message code='confirmDelete'/>");
        }

        function optSingle(opt) {
            if (Cms.checkeds("ids") == 0) {
                alert("<s:message code='pleaseSelectRecord'/>");
                return false;
            }
            if (Cms.checkeds("ids") > 1) {
                alert("<s:message code='pleaseSelectOne'/>");
                return false;
            }
            var id = $("input[name='ids']:checkbox:checked").val();
            location.href = $(opt + id).attr("href");
        }

        function optDelete(form) {
            if (Cms.checkeds("ids") == 0) {
                alert("<s:message code='pleaseSelectRecord'/>");
                return false;
            }
            if (!confirmDelete()) {
                return false;
            }
            form.action = 'delete.do';
            form.submit();
            return true;
        }

        function singleDelete(id) {
            if (!confirmDelete()) return false;
            $('#singleIds').val(id);
            $('#singleForm').attr('action', 'delete.do').submit();
        }

        $(function () {
            $("#validForm").validate();
        });
    </script>
</head>
<body class="skin-blue content-body">
<jsp:include page="/WEB-INF/views/commons/show_message.jsp" />
<form id="singleForm" method="post">
    <tags:search_params />
    <input type="hidden" id="singleIds" name="ids" value="">
</form>
<div class="content-header">
    <h1><s:message code="role.management" /> - <s:message code="list" />
        <small>(<s:message code="totalElements" arguments="${fn:length(list)}" />)</small>
    </h1>
</div>
<div class="content">
    <div class="box box-primary">
        <div class="box-body table-responsive">
            <form class="form-inline ls-search" action="list.do" method="get">
                <div class="form-group">
                    <label><s:message code="role.name" /></label>
                    <input class="form-control input-sm" type="text" name="search_CONTAIN_name" value="${search_CONTAIN_name[0]}" />
                </div>
                <button class="btn btn-default btn-sm" type="submit"><s:message code="search" /></button>
            </form>
            <form id="validForm" action="batch_update.do" method="post">
                <tags:search_params />
                <div class="btn-toolbar ls-btn-bar">
                    <div class="btn-group">
                        <shiro:hasPermission name="core:role:create">
                            <button class="btn btn-default" type="button" onclick="location.href='create.do?${searchstring}';"><s:message code="create" /></button>
                        </shiro:hasPermission>
                    </div>
                    <div class="btn-group">
                        <shiro:hasPermission name="core:role:update">
                            <button class="btn btn-default" type="submit"><s:message code="save" /></button>
                        </shiro:hasPermission>
                    </div>
                    <div class="btn-group">
                        <shiro:hasPermission name="core:role:copy">
                            <button class="btn btn-default" type="button" onclick="return optSingle('#copy_opt_');"><s:message code="copy" /></button>
                        </shiro:hasPermission>
                        <shiro:hasPermission name="core:role:edit">
                            <button class="btn btn-default" type="button" onclick="return optSingle('#edit_opt_');"><s:message code="edit" /></button>
                        </shiro:hasPermission>
                        <shiro:hasPermission name="core:role:delete">
                            <button class="btn btn-default" type="button" onclick="return optDelete(this.form);"><s:message code="delete" /></button>
                        </shiro:hasPermission>
                    </div>
                    <div class="btn-group">
                        <shiro:hasPermission name="core:workflow_step:update">
                            <button class="btn btn-default" type="button" onclick="Cms.moveTop('ids');"><s:message code='moveTop' /></button>
                            <button class="btn btn-default" type="button" onclick="Cms.moveUp('ids');"><s:message code='moveUp' /></button>
                            <button class="btn btn-default" type="button" onclick="Cms.moveDown('ids');"><s:message code='moveDown' /></button>
                            <button class="btn btn-default" type="button" onclick="Cms.moveBottom('ids');"><s:message code='moveBottom' /></button>
                        </shiro:hasPermission>
                    </div>
                </div>
                <table id="pagedTable" class="table table-condensed table-bordered table-hover ls-tb">
                    <thead id="sortHead" pagesort="<c:out value='${page_sort[0]}' />" pagedir="${page_sort_dir[0]}" pageurl="list.do?page_sort={0}&page_sort_dir={1}&${searchstringnosort}">
                    <tr class="ls_table_th">
                        <th width="25"><input type="checkbox" onclick="Cms.check('ids',this.checked);" /></th>
                        <th width="130"><s:message code="operate" /></th>
                        <th width="30" class="ls-th-sort"><span class="ls-sort" pagesort="id">ID</span></th>
                        <th class="ls-th-sort"><span class="ls-sort" pagesort="name"><s:message code="role.name" /></span></th>
                        <th class="ls-th-sort"><span class="ls-sort" pagesort="rank"><s:message code="role.rank" /></span></th>
                        <th class="ls-th-sort"><span class="ls-sort" pagesort="description"><s:message code="role.description" /></span></th>
                    </tr>
                    </thead>
                    <tbody>
                    <c:forEach var="bean" varStatus="status" items="${list}">
                        <tr beanid="${bean.id}">
                            <td><input type="checkbox" name="ids" value="${bean.id}" /></td>
                            <td align="center">
                                <shiro:hasPermission name="core:role:copy">
                                    <a id="copy_opt_${bean.id}" href="create.do?id=${bean.id}&${searchstring}" class="ls-opt"><s:message code="copy" /></a>
                                </shiro:hasPermission>
                                <shiro:hasPermission name="core:role:edit">
                                    <a id="edit_opt_${bean.id}" href="edit.do?id=${bean.id}&position=${status.index}&${searchstring}" class="ls-opt"><s:message code="edit" /></a>
                                </shiro:hasPermission>
                                <shiro:hasPermission name="core:role:delete">
                                    <a href="javascript:" onclick="singleDelete(${bean.id})" class="ls-opt"><s:message code="delete" /></a>
                                </shiro:hasPermission>
                            </td>
                            <td><c:out value="${bean.id}" /><f:hidden name="id" value="${bean.id}" /></td>
                            <td align="center"><f:text id="name_${status.index}" name="name" value="${bean.name}" class="form-control input-sm required" maxlength="100" style="width:150px;" /></td>
                            <td align="center"><f:text id="rank_${status.index}" name="rank" value="${bean.rank}" class="form-control input-sm required digits" maxlength="10" style="width:150px;" /></td>
                            <td align="center"><f:text id="description_${status.index}" name="description" value="${bean.description}" class="form-control input-sm" maxlength="255" style="width:200px;" /></td>
                        </tr>
                    </c:forEach>
                    </tbody>
                </table>
                <c:if test="${fn:length(list) le 0}">
                    <div class="ls-norecord"><s:message code="recordNotFound" /></div>
                </c:if>
            </form>
        </div>
    </div>
</div>
</body>
</html>