/**
 * Copyright (c) 2016-2020, Michael Yang 杨福海 (fuhai999@gmail.com).
 * <p>
 * Licensed under the GNU Lesser General Public License (LGPL) ,Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.jpress.model;

import io.jboot.db.annotation.Table;
import io.jboot.utils.StrUtil;
import io.jpress.model.base.BasePermission;

/**
 * Generated by Jboot.
 */
@Table(tableName = "permission", primaryKey = "id")
public class Permission extends BasePermission<Permission> {

    public static final String TYPE_ACTION = "action";
    public static final String TYPE_MENU = "menu";


    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Permission)) {
            return false;
        }

        Permission p = (Permission) o;

        return getActionKey().equals(p.getActionKey());
    }

    public String getShortNode() {
        String node = getNode();
        if (StrUtil.isBlank(node)) {
            return node;
        }

        if (!node.contains(".")) {
            return node;
        }

        String[] strings = node.split("\\.");
        return "..." + strings[strings.length - 1];
    }

    public String getTypeText() {
        switch (getType()) {
            case TYPE_ACTION:
                return "URL";
            case TYPE_MENU:
                return "菜单";
        }
        return "未知类型";
    }

    public boolean isActionPermission() {
        return TYPE_ACTION.equals(getType());
    }


    public boolean isMenuPermission() {
        return TYPE_MENU.equals(getType());
    }


}
