/**
 * Copyright (c) 2016-2020, Michael Yang 杨福海 (fuhai999@gmail.com).
 * <p>
 * Licensed under the GNU Lesser General Public License (LGPL) ,Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.jpress.module.article.model;

import io.jboot.db.annotation.Table;
import io.jpress.commons.utils.CommonsUtils;
import io.jpress.commons.utils.JsoupUtils;
import io.jpress.model.User;
import io.jpress.module.article.model.base.BaseArticleComment;

import java.util.HashMap;
import java.util.Map;

/**
 * Generated by Jboot.
 */
@Table(tableName = "article_comment", primaryKey = "id")
public class ArticleComment extends BaseArticleComment<ArticleComment> {

    public static final String STATUS_NORMAL = "normal"; //正常
    public static final String STATUS_UNAUDITED = "unaudited"; //待审核
    public static final String STATUS_TRASH = "trash"; //垃圾箱

    private static final Map<String, String> statusStrings = new HashMap<>();

    static {
        statusStrings.put(STATUS_NORMAL, "正常");
        statusStrings.put(STATUS_UNAUDITED, "待审核");
        statusStrings.put(STATUS_TRASH, "垃圾箱");
    }


    public boolean isNormal() {
        return STATUS_NORMAL.equals(getStatus());
    }

    public boolean isUnaudited() {
        return STATUS_UNAUDITED.equals(getStatus());
    }

    public boolean isTrash() {
        return STATUS_TRASH.equals(getStatus());
    }

    public String getStatusString() {
        String string = statusStrings.get(getStatus());
        return string == null ? "未知状态" : string;
    }

    @Override
    public String getAuthor() {
        User user = get("user");
        return user != null ? user.getNickname() : super.getAuthor();
    }

    public String getText() {
        return JsoupUtils.getText(getContent());
    }


    @Override
    public boolean save() {
        CommonsUtils.escapeModel(this, "content");
        JsoupUtils.clean(this, "content");
        return super.save();
    }

    @Override
    public boolean update() {
        CommonsUtils.escapeModel(this, "content");
        JsoupUtils.clean(this, "content");
        return super.update();
    }
}
