/**
 * Copyright (c) 2016-2019, Michael Yang 杨福海 (fuhai999@gmail.com).
 * <p>
 * Licensed under the GNU Lesser General Public License (LGPL) ,Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.jpress.model;

import com.jfinal.core.JFinal;
import io.jboot.db.annotation.Table;
import io.jpress.commons.layer.SortModel;
import io.jpress.commons.utils.CommonsUtils;
import io.jpress.model.base.BaseMenu;

import java.util.ArrayList;
import java.util.List;

/**
 * Generated by Jboot.
 */
@Table(tableName = "menu", primaryKey = "id")
public class Menu extends BaseMenu<Menu> implements SortModel {


    /**
     * header：前台顶部菜单；
     * main:前台主菜单；
     * footer:前台底部菜单；
     */
    public static final String TYPE_HEADER = "header"; //前台的头部菜单
    public static final String TYPE_MAIN = "main"; //前台的主菜单，一般用在左边导航或者右边导航，根据模板本身来决定的
    public static final String TYPE_FOOTER = "footer"; //前台的底部菜单


    private int layerNumber;
    private SortModel parent;
    private List<SortModel> childs;

    public boolean isTop() {
        return getPid() != null && getPid() == 0;
    }

    @Override
    public Long getParentId() {
        return getPid();
    }

    @Override
    public void setParent(SortModel parent) {
        this.parent = parent;
    }

    @Override
    public SortModel getParent() {
        return parent;
    }

    @Override
    public void setChilds(List childs) {
        this.childs = childs;
    }

    @Override
    public void addChild(SortModel child) {
        if (childs == null) {
            childs = new ArrayList<>();
        }
        childs.add(child);
    }

    @Override
    public List getChilds() {
        return childs;
    }

    public boolean hasChild() {
        return childs != null && !childs.isEmpty();
    }

    @Override
    public void setLayerNumber(int layerNumber) {
        this.layerNumber = layerNumber;
    }

    @Override
    public int getLayerNumber() {
        return layerNumber;
    }


    public String getLayerString() {
        if (layerNumber == 0) {
            return "";
        }

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < layerNumber; i++) {
            if (i == 0)
                sb.append("|—");
            else
                sb.append("—");
        }
        return sb.toString();
    }

    public boolean isMyChild(long id) {
        if (childs == null || childs.isEmpty()) {
            return false;
        }

        return isMyChild(childs, id);
    }

    private boolean isMyChild(List<SortModel> categories, long id) {
        for (SortModel category : categories) {
            if (category.getId() == id) {
                return true;
            }

            if (category.getChilds() != null) {
                boolean isChild = isMyChild(category.getChilds(), id);
                if (isChild) return true;
            }
        }
        return false;
    }

    private String baseUrl;

    private String getBaseUrl() {
        if (baseUrl == null){
            baseUrl = CommonsUtils.removeSuffix(getUrl());
        }
        return baseUrl;
    }

    private static String cp = JFinal.me().getContextPath();

    public boolean isUrlStartWidth(String url){
        return getBaseUrl() != null && getBaseUrl().startsWith(cp+url);
    }

    public boolean isUrlEquals(String url){
        return getBaseUrl() != null && getBaseUrl().equals(cp+url);
    }


}
