/**
 * Copyright (c) 2016-2019, Michael Yang 杨福海 (fuhai999@gmail.com).
 * <p>
 * Licensed under the GNU Lesser General Public License (LGPL) ,Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.jpress.model;

import io.jboot.db.annotation.Table;
import io.jpress.model.base.BaseRole;

/**
 * Generated by Jboot.
 */
@Table(tableName = "role", primaryKey = "id")
public class Role extends BaseRole<Role> {

    public static final String ADMIN_FLAG = "jpsa";

    /**
     * 是否是超级管理员的权限
     *
     * @return true : 是超级管理员，否则不是
     */
    public boolean isSuperAdmin() {
        return ADMIN_FLAG.equals(getFlag());
    }

}
