package io.jpress.model;

import io.jboot.db.annotation.Table;
import io.jpress.model.base.BaseUserCart;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Generated by JPress.
 */
@Table(tableName = "user_cart", primaryKey = "id")
public class UserCart extends BaseUserCart<UserCart> {

    private static final long serialVersionUID = 1L;

    public static final String PRODUCT_TABLE_PRODUCT = "product";
    public static final String PRODUCT_TABLE_TEXT_PRODUCT = "商品";


    public BigDecimal getShouldPayPrice() {
        if (getProductPrice() == null || getProductPrice().compareTo(BigDecimal.ZERO) == 0
                || getProductNewPrice() == null || getProductNewPrice().compareTo(BigDecimal.ZERO) == 0
        ) {
            return BigDecimal.ZERO;
        }


        return getProductNewPrice()
                .multiply(BigDecimal.valueOf(getProductCount()));
    }


    public UserFavorite toFavorite(){
        UserFavorite userFavorite = new UserFavorite();
        userFavorite.setCreated(new Date());
        userFavorite.setUserId(getUserId());
        userFavorite.setThumbnail(getProductThumbnail());
        userFavorite.setTitle(getProductTitle());
        userFavorite.setSummary(getProductSummary());
        userFavorite.setDetailPage(getProductDetailPage());

        userFavorite.setRelativeId(getProductId() == null ? null : String.valueOf(getProductId()));
        userFavorite.setRelativeTable(getProductTable());
        userFavorite.setType(getProductTable());
        userFavorite.setTypeText(getProductTableText());

        return userFavorite;
    }


}
