/*
 * Decompiled with CFR 0.152.
 */
package DBConnect;

import DBConnect.CacheDBC;
import DBConnect.DBCInstance;
import DBConnect.DBCenter;
import DBConnect.USER_PW;
import DBConnect.UpdateDBC;
import com.reflex.Object.InstanceReflexParse;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DBCTools {
    private String SRC;
    private String onlyId;
    private String DRIVER = "com.mysql.jdbc.Driver";
    private Connection CONNECTION = null;
    private Statement STATEMENT = null;
    private Map<Thread, List<Statement>> Mstatements = new HashMap<Thread, List<Statement>>();
    private Map<String, ResultSet> sqlcache = null;
    private Map<String, Statement> sqlcacheStatement = null;
    private DBCenter dbCenter = new DBCenter();
    private List<Object> list = null;
    private UpdateDBC updateDBC = new UpdateDBC(this);
    private static DBCTools tDbcTools;
    private CacheDBC cacheDBC = null;
    private InstanceReflexParse reflexParse = null;
    private String password;
    private String user;
    private String port;
    private String database;
    private String host;
    private static int poolsize;
    private static File fileParent;
    private boolean isReconnect = false;
    private Map<Thread, Integer> tableId = null;

    static {
        File file;
        block101: {
            BufferedWriter writer;
            File defaultFile;
            block95: {
                tDbcTools = null;
                poolsize = 10;
                fileParent = null;
                String path = DBCTools.class.getResource("/").getPath().substring(1);
                try {
                    path = URLDecoder.decode(path, "utf-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                fileParent = new File(String.valueOf(path) + File.separator + "DBC_DATE");
                if (!fileParent.exists()) {
                    fileParent.mkdirs();
                }
                file = new File(fileParent + File.separator + "DBCTools_core.date");
                defaultFile = new File(fileParent + File.separator + "default.date");
                writer = null;
                if (!file.exists()) {
                    try {
                        try {
                            file.createNewFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                try {
                                    writer = new BufferedWriter(new FileWriter(file));
                                    writer.write("10");
                                    writer.flush();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException e3) {
                                        e3.printStackTrace();
                                    }
                                    break block95;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e4) {
                                    e4.printStackTrace();
                                }
                                throw throwable;
                            }
                            try {
                                writer.close();
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                            break block95;
                        }
                    }
                    catch (Throwable throwable) {
                        block97: {
                            try {
                                try {
                                    writer = new BufferedWriter(new FileWriter(file));
                                    writer.write("10");
                                    writer.flush();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException e6) {
                                        e6.printStackTrace();
                                    }
                                    break block97;
                                }
                            }
                            catch (Throwable throwable2) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                throw throwable2;
                            }
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    try {
                        try {
                            writer = new BufferedWriter(new FileWriter(file));
                            writer.write("10");
                            writer.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                writer.close();
                            }
                            catch (IOException e7) {
                                e7.printStackTrace();
                            }
                            break block95;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!defaultFile.exists()) {
                try {
                    try {
                        defaultFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            try {
                                writer = new BufferedWriter(new FileWriter(defaultFile));
                                writer.write("<DBC-host></DBC-host>\r\n<DBC-port></DBC-port>\r\n<DBC-database></DBC-database>\r\n<DBC-username></DBC-username>\r\n<DBC-password></DBC-password>");
                                writer.flush();
                            }
                            catch (IOException e8) {
                                e8.printStackTrace();
                                try {
                                    writer.close();
                                }
                                catch (IOException e9) {
                                    e9.printStackTrace();
                                }
                                break block101;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                writer.close();
                            }
                            catch (IOException e10) {
                                e10.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            writer.close();
                        }
                        catch (IOException e11) {
                            e11.printStackTrace();
                        }
                        break block101;
                    }
                }
                catch (Throwable throwable) {
                    block103: {
                        try {
                            try {
                                writer = new BufferedWriter(new FileWriter(defaultFile));
                                writer.write("<DBC-host></DBC-host>\r\n<DBC-port></DBC-port>\r\n<DBC-database></DBC-database>\r\n<DBC-username></DBC-username>\r\n<DBC-password></DBC-password>");
                                writer.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                try {
                                    writer.close();
                                }
                                catch (IOException e12) {
                                    e12.printStackTrace();
                                }
                                break block103;
                            }
                        }
                        catch (Throwable throwable3) {
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable3;
                        }
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    try {
                        writer = new BufferedWriter(new FileWriter(defaultFile));
                        writer.write("<DBC-host></DBC-host>\r\n<DBC-port></DBC-port>\r\n<DBC-database></DBC-database>\r\n<DBC-username></DBC-username>\r\n<DBC-password></DBC-password>");
                        writer.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            writer.close();
                        }
                        catch (IOException e13) {
                            e13.printStackTrace();
                        }
                        break block101;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                try {
                    poolsize = Integer.parseInt(reader.readLine().trim());
                    if (poolsize > 50) {
                        poolsize = 50;
                    } else if (poolsize < 1) {
                        poolsize = 1;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    file.delete();
                    System.exit(-1);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    reader.close();
                }
                catch (IOException e14) {
                    e14.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    reader.close();
                }
                catch (IOException e15) {
                    e15.printStackTrace();
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setIsReconnect(boolean isReconnect) {
        this.isReconnect = isReconnect;
    }

    private DBCTools(String onlyID) {
        this.sqlcache = new HashMap<String, ResultSet>();
        this.sqlcacheStatement = new HashMap<String, Statement>();
        this.reflexParse = InstanceReflexParse.getReflexParse();
        this.onlyId = onlyID;
        this.list = new ArrayList<Object>();
        this.tableId = this.dbCenter.getTableId();
    }

    public void sqlCacheClear() {
        this.sqlcacheStatement.clear();
        this.sqlcache.clear();
    }

    private void selectPluls() {
        if (this.isReconnect) {
            this.reconnection();
        }
    }

    public ResultSet selectQueryAllCache(String tableViewName, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            try {
                this.selectPluls();
                if (this.sqlcache.containsKey(tableViewName)) {
                    return this.sqlcache.get(tableViewName);
                }
                Statement statement = this.getStatement();
                this.sqlcacheStatement.put(tableViewName, statement);
                this.sqlcache.put(tableViewName, statement.executeQuery(DBCTools.parseSQL("select * from " + tableViewName, fieldSize)));
                return this.sqlcache.get(tableViewName);
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    public ResultSet selectQueryAllList(String tableViewName, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            try {
                this.selectPluls();
                String sql = DBCTools.parseSQL("select * from " + tableViewName, fieldSize);
                if (this.Mstatements.get(Thread.currentThread()) != null) {
                    this.Mstatements.get(Thread.currentThread()).add(this.CONNECTION.createStatement());
                    return this.Mstatements.get(Thread.currentThread()).get(this.Mstatements.get(Thread.currentThread()).size() - 1).executeQuery(sql);
                }
                this.Mstatements.put(Thread.currentThread(), new ArrayList());
                this.Mstatements.get(Thread.currentThread()).add(this.CONNECTION.createStatement());
                return this.Mstatements.get(Thread.currentThread()).get(this.Mstatements.get(Thread.currentThread()).size() - 1).executeQuery(sql);
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    private String parseFormat(String oldString) {
        oldString = oldString.replace("'", "");
        return oldString.replace("\"", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countTable(String tableViewName) {
        if (!this.isNotConnectNull()) {
            return 0;
        }
        Statement statement = this.getStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("select count(*) as C from " + tableViewName);
            if (resultSet.next()) {
                int count;
                int n = count = resultSet.getInt("C");
                this.closeQuery(statement, resultSet);
                return n;
            }
            this.closeQuery(statement, resultSet);
            return 0;
        }
        catch (SQLException e) {
            return 0;
        }
        finally {
            this.closeQuery(statement, resultSet);
        }
    }

    public ResultSet selectQueryList(String sql, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            try {
                this.selectPluls();
                sql = DBCTools.parseSQL(sql, fieldSize);
                if (this.Mstatements.get(Thread.currentThread()) != null) {
                    this.Mstatements.get(Thread.currentThread()).add(this.CONNECTION.createStatement());
                    return this.Mstatements.get(Thread.currentThread()).get(this.Mstatements.get(Thread.currentThread()).size() - 1).executeQuery(sql);
                }
                this.Mstatements.put(Thread.currentThread(), new ArrayList());
                this.Mstatements.get(Thread.currentThread()).add(this.CONNECTION.createStatement());
                return this.Mstatements.get(Thread.currentThread()).get(this.Mstatements.get(Thread.currentThread()).size() - 1).executeQuery(sql);
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    public boolean reconnection() {
        this.close(true);
        return this.createConnect(this.host, this.database, this.port, this.user, this.password);
    }

    public ResultSet selectQueryCache(String sql, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            try {
                this.selectPluls();
                if (this.sqlcache.containsKey(sql)) {
                    return this.sqlcache.get(sql);
                }
                Statement statement = this.getStatement();
                this.sqlcacheStatement.put(sql, statement);
                this.sqlcache.put(sql, statement.executeQuery(DBCTools.parseSQL(sql, fieldSize)));
                return this.sqlcache.get(sql);
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    public Statement getStatement() {
        if (this.isNotConnectNull()) {
            try {
                return this.CONNECTION.createStatement();
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    public void CloseStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean callProcedure(String procedure) {
        if (this.isNotConnectNull()) {
            CallableStatement callableStatement = null;
            try {
                callableStatement = this.CONNECTION.prepareCall(procedure);
                boolean bl = callableStatement.execute();
                return bl;
            }
            catch (SQLException e) {
                return false;
            }
            finally {
                try {
                    this.CONNECTION.commit();
                    callableStatement.close();
                    this.sqlCacheClear();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private void setId(String tableName) {
        if (this.isNotConnectNull()) {
            Statement statement = this.getStatement();
            ResultSet resultSet = null;
            try {
                try {
                    resultSet = statement.executeQuery("select Max(id) as M from " + tableName);
                    if (resultSet.next()) {
                        this.tableId.put(Thread.currentThread(), resultSet.getInt("M"));
                    }
                }
                catch (SQLException e) {
                    this.closeQuery(statement, resultSet);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.closeQuery(statement, resultSet);
                throw throwable;
            }
            this.closeQuery(statement, resultSet);
        }
    }

    public int getId() {
        return this.tableId.get(Thread.currentThread());
    }

    public void removeId() {
        this.tableId.remove(Thread.currentThread());
    }

    public int update(String sql, String tableName, Integer fieldSize) {
        return this.update(DBCTools.parseSQL(sql, fieldSize), tableName);
    }

    public int update(String sql) {
        return this.update(sql, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, String ... tableName) {
        if (this.isNotConnectNull()) {
            if (this.cacheDBC != null) {
                return this.flushCache(DBCTools.parseSQL(sql, new Integer[0]));
            }
            try {
                int i = 0;
                DBCTools dBCTools = this;
                synchronized (dBCTools) {
                    if (tableName != null && tableName.length > 0) {
                        i = this.STATEMENT.executeUpdate(DBCTools.parseSQL(sql, new Integer[0]));
                        this.CONNECTION.commit();
                        this.setId(tableName[0]);
                    } else {
                        i = this.STATEMENT.executeUpdate(DBCTools.parseSQL(sql, new Integer[0]));
                        this.CONNECTION.commit();
                    }
                }
                int n = i;
                return n;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return 0;
            }
            finally {
                this.sqlCacheClear();
            }
        }
        return 0;
    }

    public int update(String sql, Integer ... fieldSize) {
        return this.update(DBCTools.parseSQL(sql, fieldSize), fieldSize);
    }

    public int deleteId(Integer id, String tableName) {
        return this.delete("id=" + id.toString(), tableName, new Integer[0]);
    }

    public int delete(String condition, String tableName, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            return this.update("delete from " + tableName + " where " + condition, fieldSize);
        }
        return 0;
    }

    public Object getInfoById(String columName, int id, String tableName) {
        return this.getSingeInfo(columName, "id=" + id, tableName, 1);
    }

    public Object getSingeInfo(String columName, String condition, String tableName, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            Object object = null;
            Statement statement = this.getStatement();
            ResultSet resultSet = this.selectQuery(statement, "select " + columName + " from " + tableName + " where " + condition + " group by " + columName, fieldSize);
            try {
                try {
                    if (resultSet.next()) {
                        object = resultSet.getObject(columName);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
            this.closeQuery(statement, resultSet);
            return object;
        }
        return null;
    }

    public Object[] getSingInfoOneList(String columName, int id, String tableName) {
        if (this.isNotConnectNull()) {
            Object[] object = null;
            Statement statement = this.getStatement();
            ResultSet resultSet = this.selectQuery(statement, "select " + columName + " from " + tableName + " where id=" + id + " group by id", new Integer[0]);
            Object[] colums = columName.split("[,]");
            if ("*".equals(colums[0])) {
                object = new Object[this.getDescNameSize(tableName)];
                List<Object> descName = this.getDescName(tableName);
                colums = descName.toArray();
            } else {
                object = new Object[colums.length];
            }
            int index = object.length;
            try {
                try {
                    int tj = 0;
                    if (resultSet.next()) {
                        int i = 0;
                        while (i < index) {
                            object[i] = resultSet.getObject(colums[i].toString());
                            ++i;
                        }
                        ++tj;
                    }
                    if (tj == 0) {
                        // empty if block
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
            this.closeQuery(statement, resultSet);
            return object;
        }
        return null;
    }

    public Object[] getArrayInfo(String columName, String condition, String tableName) {
        if (this.isNotConnectNull()) {
            Object[] object = new Object[this.countTable(String.valueOf(tableName) + " where " + condition)];
            Statement statement = this.getStatement();
            ResultSet resultSet = this.selectQuery(statement, "select " + columName + " from " + tableName + " where " + condition, new Integer[0]);
            try {
                try {
                    int i = 0;
                    while (resultSet.next()) {
                        object[i] = resultSet.getObject(columName);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
            this.closeQuery(statement, resultSet);
            return object;
        }
        return null;
    }

    public void updateList(List<String> sqList, List<Integer> ... fieldSize) {
        if (this.isNotConnectNull()) {
            try {
                try {
                    boolean is = false;
                    if (fieldSize != null && fieldSize.length > 0) {
                        is = true;
                    }
                    int i = 0;
                    while (i < sqList.size()) {
                        if (is) {
                            this.STATEMENT.addBatch(DBCTools.parseSQL(sqList.get(i), fieldSize[0].get(i)));
                        } else {
                            this.STATEMENT.addBatch(DBCTools.parseSQL(sqList.get(i), new Integer[0]));
                        }
                        if (i % 5000 == 0) {
                            this.STATEMENT.executeBatch();
                            this.CONNECTION.commit();
                        }
                        ++i;
                    }
                    this.STATEMENT.executeBatch();
                    this.CONNECTION.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.sqlCacheClear();
                    if (this.cacheDBC != null) {
                        this.cacheDBC.reStartCache(this);
                    }
                }
            }
            finally {
                this.sqlCacheClear();
                if (this.cacheDBC != null) {
                    this.cacheDBC.reStartCache(this);
                }
            }
        }
    }

    public static String parseSQL(String sql, Integer ... fieldSize) {
        if (fieldSize == null || fieldSize.length == 0) {
            return sql;
        }
        int count = DBCTools.countEncoding(sql, "'");
        if (count / 2 != fieldSize[0]) {
            return "";
        }
        return sql;
    }

    private static int countEncoding(String value, String en) {
        int count = 0;
        while (value.indexOf(en) != -1) {
            ++count;
        }
        return count;
    }

    public List<Object> getDescName(String tableName) {
        ArrayList<Object> names = new ArrayList<Object>();
        Statement st = this.getStatement();
        ResultSet resultSet = this.selectQuery(st, "desc " + tableName, new Integer[0]);
        try {
            try {
                while (resultSet.next()) {
                    names.add(resultSet.getObject("field"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.closeQuery(st, resultSet);
            }
        }
        finally {
            this.closeQuery(st, resultSet);
        }
        return names;
    }

    public ResultSet selectQueryAll(Statement statement, String tableName, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(DBCTools.parseSQL("select * from " + tableName, fieldSize));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return resultSet;
        }
        return null;
    }

    public ResultSet selectQuery(Statement statement, String sql, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(DBCTools.parseSQL(sql, fieldSize));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return resultSet;
        }
        return null;
    }

    public void closeQuery(Statement st, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public int getDescNameSize(String tableName) {
        Statement statement = this.getStatement();
        ResultSet resultSet = this.selectQueryList("desc " + tableName, new Integer[0]);
        int size = 0;
        try {
            try {
                while (resultSet.next()) {
                    ++size;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.closeQuery(statement, resultSet);
            }
        }
        finally {
            this.closeQuery(statement, resultSet);
        }
        return size;
    }

    public <T> List<T> getListByName(Class<T> entity, String ... tableName) {
        return this.updateDBC.getListByName(entity, tableName);
    }

    public <T> List<T> getListByNameLimit(Class<T> entity, int index, int size, String ... tableName) {
        return this.updateDBC.getListByNameLimit(entity, index, size, tableName);
    }

    public <T> T getSingeByName(Integer id, T entity, String ... tableName) throws Exception {
        return this.updateDBC.getSingeByName(id, entity, tableName);
    }

    public void setObjectByName(Object entity, String ... tableName) throws Exception {
        this.updateDBC.setObjectByName(entity, tableName);
    }

    public boolean CacheOpen(String tabel_view, String ColumIndexName, String ... columNames) {
        this.cacheDBC = CacheDBC.getCacheDBC(this.dbCenter, this);
        if (this.cacheDBC.CacheOpen(tabel_view, ColumIndexName, columNames)) {
            this.dbCenter.getTable_GetName().put(tabel_view.trim(), columNames);
            this.dbCenter.getTable_GetIndexName().put(tabel_view.trim(), ColumIndexName.trim());
            return true;
        }
        return false;
    }

    public void closeCache_C() {
        this.cacheDBC.close();
        this.cacheDBC = null;
    }

    public boolean ProvingUO_C(String value, String[] values, String ... table) {
        if (this.isCacheOpen()) {
            USER_PW user_PW = this.cacheDBC.getMapValue(value, table);
            if (user_PW == null) {
                return false;
            }
            if (values == null || values.length == 0) {
                return true;
            }
            long object1 = 0L;
            int i = 0;
            while (i < user_PW.getColums().length) {
                object1 += (long)("" + user_PW.getColum(i)).hashCode();
                ++i;
            }
            long object2 = 0L;
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                object2 += (long)String.valueOf(string).hashCode();
                ++n2;
            }
            return object2 == object1;
        }
        return false;
    }

    public boolean ProvingUO_C(String value, String[] columName, String[] values, String ... table) {
        if (this.isCacheOpen()) {
            USER_PW user_PW = this.cacheDBC.getMapValue(value, table);
            if (user_PW == null) {
                return false;
            }
            if (columName == null || values == null || columName.length == 0 || values.length == 0) {
                return true;
            }
            String object1 = "";
            boolean flag = true;
            HashMap<String, String> valueServer = new HashMap<String, String>();
            int i = 0;
            while (i < columName.length) {
                int index = -1;
                int j = 0;
                while (j < this.dbCenter.getTable_GetName().get(user_PW.getTable()).length) {
                    if (columName[i].equalsIgnoreCase(this.dbCenter.getTable_GetName().get(user_PW.getTable())[j])) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                if (index != -1) {
                    object1 = String.valueOf(object1) + user_PW.getColum(index);
                } else if (flag) {
                    block18: {
                        ResultSet resultSet = this.selectQueryList("select * from " + user_PW.getTable() + " where id=" + user_PW.getId(), new Integer[0]);
                        try {
                            try {
                                if (resultSet.next()) {
                                    int j2 = 1;
                                    while (j2 < resultSet.getMetaData().getColumnCount() + 1) {
                                        valueServer.put(resultSet.getMetaData().getColumnName(j2), resultSet.getObject(j2).toString());
                                        ++j2;
                                    }
                                }
                                object1 = String.valueOf(object1) + (String)valueServer.get(columName[i]);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                this.CloseList();
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            this.CloseList();
                            throw throwable;
                        }
                        this.CloseList();
                    }
                    flag = false;
                } else {
                    object1 = String.valueOf(object1) + (String)valueServer.get(columName[i]);
                }
                ++i;
            }
            valueServer.clear();
            valueServer = null;
            String object2 = "";
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                object2 = String.valueOf(object2) + string;
                ++n2;
            }
            return object2.equals(object1);
        }
        return false;
    }

    public int getCacheId_C(String value, String ... table) {
        if (this.isCacheOpen()) {
            return this.cacheDBC.getMapValue(value, table).getId();
        }
        return 0;
    }

    public Object[] getColum_C(String value, String[] columNames, String ... table) {
        if (this.isCacheOpen()) {
            if (columNames == null) {
                return null;
            }
            Object[] objects = new Object[columNames.length];
            int i = 0;
            while (i < objects.length) {
                objects[i] = this.getColum_C(value, columNames[i], table);
                ++i;
            }
            return objects;
        }
        return null;
    }

    public Object getColum_C(String value, String columName, String ... table) {
        if (this.isCacheOpen()) {
            if (columName == null) {
                return null;
            }
            USER_PW user_PW = this.cacheDBC.getMapValue(value, table);
            if (user_PW == null) {
                return null;
            }
            if (columName.equalsIgnoreCase(this.dbCenter.getTable_GetIndexName().get(user_PW.getTable()))) {
                return user_PW.getUsername();
            }
            int index = -1;
            int i = 0;
            while (i < this.dbCenter.getTable_GetName().get(user_PW.getTable()).length) {
                if (columName.equalsIgnoreCase(this.dbCenter.getTable_GetName().get(user_PW.getTable())[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                return user_PW.getColum(index);
            }
            ResultSet resultSet = this.selectQueryList("select T." + columName + " from " + user_PW.getTable() + " T where id=" + user_PW.getId(), new Integer[0]);
            try {
                if (resultSet.next()) {
                    Object object = resultSet.getObject(columName);
                    return object;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.CloseList();
            }
        }
        return null;
    }

    private int flushCache(String sql) {
        String value = sql.trim().split(" ")[0];
        if ("update".equalsIgnoreCase(value)) {
            return this.updateCache(sql.trim(), sql);
        }
        if ("delete".equalsIgnoreCase(value)) {
            return this.deleteCache(sql.trim().split("(?i)from")[1].trim(), sql);
        }
        if ("insert".equalsIgnoreCase(value)) {
            return this.insertCache(sql.trim().split("(?i)into")[1].trim(), sql);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int updateCache(String sql, String sourceSQL) {
        int upsize;
        String table;
        block37: {
            Statement statement = this.getStatement();
            table = sql.substring(sql.indexOf(" "), sql.indexOf("set")).trim();
            if (this.dbCenter.getTable_GetIndexName().get(table) == null) {
                try {
                    int n = statement.executeUpdate(sourceSQL);
                    return n;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        this.CONNECTION.commit();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    this.CloseStatement(statement);
                }
            }
            upsize = 0;
            if (sql.toLowerCase().indexOf("where") != -1) {
                sql = "select * from " + table + " where " + sql.split("(?i)where")[1].trim();
                ResultSet resultSet = this.selectQueryList(sql, new Integer[0]);
                try {
                    try {
                        if (this.list.size() > 0) {
                            this.list.clear();
                        }
                        while (resultSet.next()) {
                            USER_PW user_PW = this.cacheDBC.getMapValue(resultSet.getObject(this.dbCenter.getTable_GetIndexName().get(table)).toString(), table);
                            user_PW.setId(resultSet.getInt("id"));
                            this.list.add(user_PW);
                            this.cacheDBC.remove(user_PW.getUsername(), table);
                        }
                        upsize = statement.executeUpdate(sourceSQL);
                        this.CONNECTION.commit();
                        if (upsize <= 0) return upsize;
                        for (Object object : this.list) {
                            sql = "select * from " + table + " where id=" + ((USER_PW)object).getId();
                            resultSet = this.selectQueryList(sql, new Integer[0]);
                            if (resultSet.next()) {
                                ((USER_PW)object).setUsername(resultSet.getObject(this.dbCenter.getTable_GetIndexName().get(table)).toString());
                                Object[] colums = new Object[this.dbCenter.getTable_GetName().get(table).length];
                                int i = 0;
                                while (i < colums.length) {
                                    colums[i] = resultSet.getObject(this.dbCenter.getTable_GetName().get(table)[i]);
                                    ++i;
                                }
                                ((USER_PW)object).setColums(colums);
                            }
                            this.cacheDBC.addMapValue(((USER_PW)object).getUsername(), (USER_PW)object, table);
                        }
                        return upsize;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (this.list.size() > 0) {
                            this.list.clear();
                        }
                        this.CloseList();
                        this.CloseStatement(statement);
                    }
                    return upsize;
                }
                finally {
                    if (this.list.size() > 0) {
                        this.list.clear();
                    }
                    this.CloseList();
                    this.CloseStatement(statement);
                }
            }
            this.cacheDBC.removeTable(this, table);
            try {
                try {
                    upsize = statement.executeUpdate(sourceSQL);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    try {
                        this.CONNECTION.commit();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    this.CloseStatement(statement);
                    break block37;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.CONNECTION.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.CloseStatement(statement);
                throw throwable;
            }
            try {
                this.CONNECTION.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.CloseStatement(statement);
        }
        if (upsize <= 0) return upsize;
        this.cacheDBC.CacheOpen(table, this.dbCenter.getTable_GetIndexName().get(table), this.dbCenter.getTable_GetName().get(table));
        return upsize;
    }

    private int deleteCache(String sql, String sourceSQL) {
        Statement statement = this.getStatement();
        String table = sql.substring(0, sql.indexOf(" ")).trim();
        if (this.dbCenter.getTable_GetIndexName().get(table) == null) {
            try {
                int n = statement.executeUpdate(sourceSQL);
                return n;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.CONNECTION.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.CloseStatement(statement);
            }
        }
        sql = "select * from " + sql;
        ResultSet resultSet = this.selectQueryList(sql, new Integer[0]);
        int upsize = 0;
        try {
            try {
                if (this.list.size() > 0) {
                    this.list.clear();
                }
                while (resultSet.next()) {
                    this.list.add(resultSet.getObject(this.dbCenter.getTable_GetIndexName().get(table)));
                }
                upsize = statement.executeUpdate(sourceSQL);
                this.CONNECTION.commit();
                if (upsize > 0) {
                    for (Object object : this.list) {
                        this.cacheDBC.remove(object.toString(), table);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        try {
            this.CloseList();
            this.CloseStatement(statement);
        }
        catch (Throwable throwable) {}
        return upsize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int insertCache(String sql, String sourceSQL) {
        Statement statement = this.getStatement();
        String table = sql.substring(0, sql.indexOf("(")).trim();
        if (this.dbCenter.getTable_GetIndexName().get(table) == null) {
            try {
                int n = statement.executeUpdate(sourceSQL);
                return n;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.CONNECTION.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.CloseStatement(statement);
            }
        }
        int upsize = 0;
        if (sql.split("(?i)values")[0].indexOf("(") != -1) {
            String value = null;
            String[] names = sql.substring(sql.indexOf("(") + 1, sql.indexOf(")")).split(",");
            String[] valuse = sql.split("(?i)values")[1].trim().substring(1, sql.split("(?i)values")[1].trim().length() - 1).split(",");
            int i = 0;
            while (i < names.length) {
                if (this.dbCenter.getTable_GetIndexName().get(table).equalsIgnoreCase(names[i].trim())) {
                    value = valuse[i].trim();
                    break;
                }
                ++i;
            }
            try {
                upsize = statement.executeUpdate(sourceSQL);
                this.CONNECTION.commit();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            if (upsize <= 0) return upsize;
            sql = "select * from " + table + " where " + this.dbCenter.getTable_GetIndexName().get(table) + "=" + value;
            ResultSet resultSet = this.selectQueryList(sql, new Integer[0]);
            try {
                try {
                    if (!resultSet.next()) return upsize;
                    int id = resultSet.getInt("id");
                    Object[] colums = new Object[this.dbCenter.getTable_GetName().get(table).length];
                    int i2 = 0;
                    while (i2 < colums.length) {
                        colums[i2] = resultSet.getObject(this.dbCenter.getTable_GetName().get(table)[i2]);
                        ++i2;
                    }
                    this.cacheDBC.addMapValue(this.parseFormat(value), new USER_PW(this.parseFormat(value), id, table, colums), table);
                    return upsize;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.CloseList();
                    this.CloseStatement(statement);
                }
                return upsize;
            }
            finally {
                this.CloseList();
                this.CloseStatement(statement);
            }
        }
        int id = Integer.parseInt(sql.substring(sql.indexOf("(") + 1, sql.indexOf(")")).split(",")[0].trim());
        try {
            upsize = statement.executeUpdate(sourceSQL);
            this.CONNECTION.commit();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        if (upsize <= 0) return upsize;
        sql = "select * from " + table + " where id=" + id;
        ResultSet resultSet = this.selectQueryList(sql, new Integer[0]);
        try {
            try {
                if (!resultSet.next()) return upsize;
                String value = resultSet.getObject(this.dbCenter.getTable_GetIndexName().get(table)).toString();
                Object[] colums = new Object[this.dbCenter.getTable_GetName().get(table).length];
                int i = 0;
                while (i < colums.length) {
                    colums[i] = resultSet.getObject(this.dbCenter.getTable_GetName().get(table)[i]);
                    ++i;
                }
                this.cacheDBC.addMapValue(value, new USER_PW(value, id, table, colums), table);
                return upsize;
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.CloseList();
                this.CloseStatement(statement);
            }
            return upsize;
        }
        finally {
            this.CloseList();
            this.CloseStatement(statement);
        }
    }

    public void reStartCache_C(DBCTools dbcTools) {
        this.cacheDBC.reStartCache(dbcTools);
    }

    public DBCenter getDBCenter() {
        return this.dbCenter;
    }

    private boolean isCacheOpen() {
        if (this.cacheDBC == null) {
            System.err.println("\n*********\u7f13\u5b58\u672a\u6253\u5f00\uff0c\u8bf7CacheOpen\u4e4b\u540e\u64cd\u4f5c\uff01**********\n");
            return false;
        }
        return true;
    }

    public boolean commit(List<String> sqlCommits, Integer ... fieldSize) {
        if (this.isNotConnectNull()) {
            Statement statement = this.getStatement();
            try {
                try {
                    for (String string : sqlCommits) {
                        statement.executeUpdate(DBCTools.parseSQL(string, fieldSize));
                    }
                    this.CONNECTION.commit();
                }
                catch (SQLException e1) {
                    try {
                        this.CONNECTION.rollback();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    this.CloseStatement(statement);
                    this.sqlCacheClear();
                    return false;
                }
            }
            finally {
                this.CloseStatement(statement);
                this.sqlCacheClear();
            }
            return true;
        }
        return false;
    }

    public void CloseList() {
        if (this.Mstatements.get(Thread.currentThread()) == null) {
            return;
        }
        for (Statement statement : this.Mstatements.get(Thread.currentThread())) {
            if (statement == null) continue;
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.Mstatements.remove(Thread.currentThread());
    }

    public boolean close(boolean flag) {
        if (this.STATEMENT != null) {
            try {
                this.STATEMENT.close();
                this.STATEMENT = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.CONNECTION != null) {
            try {
                this.CONNECTION.close();
                this.CONNECTION = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean close(Object entity) throws Exception {
        int isclear = this.reflexParse.setNullAll(DBCTools.class, entity.getClass(), entity, 0);
        if (isclear == 0) {
            return false;
        }
        if (!this.close(true)) {
            return false;
        }
        DBCInstance.DBCINSTANCE.geDbcTools().remove(DBCTools.getIDTools(this.getOnlyId()));
        DBCInstance.DBCINSTANCE.getDbcPw().remove(this.getOnlyId());
        tDbcTools = null;
        return true;
    }

    protected String getOnlyId() {
        return this.onlyId;
    }

    public boolean createConnect(String host, String database, String port, String user, String password) {
        if (this.CONNECTION == null) {
            if (this.forClass()) {
                try {
                    this.SRC = "jdbc:mysql://" + host + ":" + port + "/" + database + "?serverTimezone=UTC&connectTimeout=10000&socketTimeout=10000";
                    this.CONNECTION = DriverManager.getConnection(this.SRC, user, password);
                    this.host = host;
                    this.database = database;
                    this.port = port;
                    this.user = user;
                    this.password = password;
                    this.STATEMENT = this.CONNECTION.createStatement();
                    this.CONNECTION.setAutoCommit(false);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            System.err.println("\n*********JDBC\u9a71\u52a8\u6ca1\u627e\u5230!!!  \u8bf7\u4fdd\u8bc1\u6709\u6570\u636e\u5e93\u4f9d\u8d56\u5305!*********\n");
            return false;
        }
        System.err.println("\n*********\u5df2\u5b58\u5728Connection!!!  \u8bf7\u5148Close\u8fde\u63a5!*********\n");
        return false;
    }

    public static synchronized DBCTools getDbcTools(String onlyID, String host, String port, String database, String username, String password) {
        int i = 0;
        while (i < DBCInstance.DBCINSTANCE.getDbcPw().size()) {
            if (onlyID.equals(DBCInstance.DBCINSTANCE.getDbcPw().get(i))) {
                return DBCInstance.DBCINSTANCE.geDbcTools().get(i);
            }
            ++i;
        }
        if (DBCInstance.DBCINSTANCE.geDbcTools().size() > poolsize) {
            DBCInstance.DBCINSTANCE.geDbcTools().get(poolsize).close(false);
            DBCInstance.DBCINSTANCE.getDbcPw().set(poolsize, onlyID);
            DBCInstance.DBCINSTANCE.geDbcTools().get(poolsize).createConnect(host, database, port, username, password);
            return DBCInstance.DBCINSTANCE.geDbcTools().get(poolsize);
        }
        tDbcTools = new DBCTools(onlyID);
        if (tDbcTools.createConnect(host, database, port, username, password)) {
            DBCInstance.DBCINSTANCE.geDbcTools().add(tDbcTools);
            DBCInstance.DBCINSTANCE.getDbcPw().add(onlyID);
        } else {
            tDbcTools.close(false);
            tDbcTools = null;
        }
        return tDbcTools;
    }

    public static synchronized DBCTools getDbcTools(String onlyID, String fileName) {
        int i = 0;
        while (i < DBCInstance.DBCINSTANCE.getDbcPw().size()) {
            if (onlyID.equals(DBCInstance.DBCINSTANCE.getDbcPw().get(i))) {
                return DBCInstance.DBCINSTANCE.geDbcTools().get(i);
            }
            ++i;
        }
        File file = new File(fileParent + File.separator + fileName);
        if (!file.exists()) {
            System.err.println("\n*********\u6587\u4ef6\u4e0d\u5b58\u5728\uff01**********\n");
            return null;
        }
        String[] DBCF = new String[]{"<DBC-host>", "<DBC-port>", "<DBC-database>", "<DBC-username>", "<DBC-password>"};
        String[] DBCL = new String[]{"</DBC-host>", "</DBC-port>", "</DBC-database>", "</DBC-username>", "</DBC-password>"};
        String[] values = DBCTools.readDate(DBCF, DBCL, file);
        if (values == null) {
            return null;
        }
        return DBCTools.getDbcTools(onlyID, values[0], values[1], values[2], values[3], values[4]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readDate(String[] Frist, String[] Last, File file) {
        String[] values = new String[Frist.length];
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String info = null;
            StringBuffer buffer = new StringBuffer();
            String value = null;
            boolean flag = false;
            block15: while (true) {
                if ((info = reader.readLine()) == null) {
                    String[] stringArray = values;
                    return stringArray;
                }
                int i = 0;
                while (true) {
                    block24: {
                        int Lindex;
                        if (i >= Frist.length) continue block15;
                        int Findex = info.indexOf(Frist[i]);
                        if (Findex != -1) {
                            flag = true;
                            Lindex = info.indexOf(Last[i]);
                            if (Lindex != -1) {
                                flag = false;
                                value = info.substring(Findex, Lindex);
                                values[i] = value.substring(value.indexOf(">") + 1, value.length()).trim();
                                info = info.substring(info.indexOf(">", info.indexOf(">") + 1) + 1);
                                break block24;
                            } else {
                                value = info.substring(info.indexOf(">") + 1).trim();
                                buffer.append(value);
                                continue block15;
                            }
                        }
                        Lindex = info.indexOf(Last[i]);
                        if (Lindex != -1) {
                            flag = false;
                            value = info.substring(0, Lindex).trim();
                            buffer.append(value);
                            values[i] = buffer.toString();
                            buffer.setLength(0);
                            info = info.substring(info.indexOf(">") + 1);
                        } else if (i == Frist.length - 1) {
                            if (!flag) continue block15;
                            buffer.append(info.trim());
                            continue block15;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isNotConnectNull() {
        if (this.CONNECTION != null) {
            return true;
        }
        if (this.reconnection()) {
            return true;
        }
        System.err.println("\n**********Connection\u4e3a\u7a7a\uff01  \u5730\u5740\u5bc6\u7801\u8d26\u53f7\u53ef\u80fd\u4e0d\u5bf9\uff01***********\n");
        return false;
    }

    public Connection getConnection() {
        return this.CONNECTION;
    }

    public static DBCTools getIDTools(String onlyID) {
        int i = 0;
        while (i < DBCInstance.DBCINSTANCE.getDbcPw().size()) {
            if (onlyID.equals(DBCInstance.DBCINSTANCE.getDbcPw().get(i))) {
                return DBCInstance.DBCINSTANCE.geDbcTools().get(i);
            }
            ++i;
        }
        return null;
    }

    private boolean forClass() {
        try {
            Class.forName(this.DRIVER);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

