# Overview

In the AIO application, we offer the reader the option to download each example as a full self-contained
runnable project packaged as a zip file. These zip files are generated by the utility in this folder.

## Example zipper

The `exampleZipper.js` tool is very similar to the Stackblitz's `builder.js`. The latter creates an HTML file
with all the examples' files and the former creates a zip file instead. They both use the `stackblitz.json` file
to flag an example as something to stackblitz or zip. For example:

```json
{
  "description": "Tour of Heroes: Part 6",
  "files":[
    "!**/*.d.ts",
    "!**/*.js",
    "!**/*.[1,2].*"
  ],
  "tags": ["tutorial", "tour", "heroes", "http"]
}
```

The zipper will use this information for creating new zips.

## Three kinds of examples

The majority of examples in AIO use `CLI`, with some additionally using `Webpack` and upgrade usiing `SystemJS`. This
tool is able to differentiate between them.

The boilerplate uses a `package.json` that contains packages and scripts to run any kind of example.
Using that `package.json` in the zips would confuse the users.

Thanks to the `package.json` customizer, we can create a new `package.json` on the fly that would
only contain the packages and scripts needed to run that example.

The `exampleZipper.js` won't include any `System.js` related files for `CLI` or `Webpack` projects.

### The package.json customizer

Given a `type`, this tool will populate a `package.json` file customized for that type.

Here you find a:

* **base.json** - All the common scripts and packages
* **cli.json** - Extra scripts and packages for the CLI
* **universal.json** - Extra scripts and packages for universal
* **i18n.json** - Extra scripts and packages for i18n
* **systemjs.json** - All the System.js related packages but it also contains the remainder scripts
  that are not in the other files.

The tool will also give some standard names to the scripts.

## The zipper.json

As mentioned, the tool uses the `stackblitz.json` as a flag and also a configuration file for the zipper.
The problem is that not all examples have a stackblitz but they could offer a zip instead.

In those cases, you can create a `zipper.json` file with the same syntax. It will be ignored by the
stackblitz tool.

## Choosing the zip "type"

In both `stackblitz.json` and `zipper.json` you can use two extra properties for the zipper configuration:

```
{
  ...
  "removeSystemJsConfig": true,
  "type": "testing"
}
```

This would generate a zip for a testing application and it will also remove everything related with
SystemJS.

## Executing the zip generation

`generateZips.js` will create a zip for each `stackblitz.json`  or `zipper.json` it finds.

Where? At `src/generated/zips/`.

Then the `<live-example>` embedded component will look at this folder to get the zip it needs for
the example.
