/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteArrayInput;
import com.dyuproject.protostuff.FilterInput;
import com.dyuproject.protostuff.GraphInput;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.UninitializedMessageException;
import com.dyuproject.protostuff.WireFormat;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphByteArrayInput
extends FilterInput<ByteArrayInput>
implements GraphInput,
Schema<Object> {
    private final ArrayList<Object> references;
    private int lastRef = -1;
    private Schema<Object> lastSchema;
    private boolean messageReference = false;

    public GraphByteArrayInput(ByteArrayInput input) {
        super(input);
        assert (input.decodeNestedMessageAsGroup);
        this.references = new ArrayList();
    }

    public GraphByteArrayInput(ByteArrayInput input, int initialCapacity) {
        super(input);
        assert (input.decodeNestedMessageAsGroup);
        this.references = new ArrayList(initialCapacity);
    }

    @Override
    public void updateLast(Object morphedMessage, Object lastMessage) {
        int last = this.references.size() - 1;
        if (lastMessage != null && lastMessage == this.references.get(last)) {
            this.references.set(last, morphedMessage);
        }
    }

    @Override
    public boolean isCurrentMessageReference() {
        return this.messageReference;
    }

    @Override
    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        int fieldNumber = ((ByteArrayInput)this.input).readFieldNumber(schema);
        if (WireFormat.getTagWireType(((ByteArrayInput)this.input).getLastTag()) == 6) {
            this.lastRef = ((ByteArrayInput)this.input).readUInt32();
            this.messageReference = true;
        } else {
            this.messageReference = false;
        }
        return fieldNumber;
    }

    @Override
    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.messageReference) {
            return (T)this.references.get(this.lastRef);
        }
        this.lastSchema = schema;
        if (value == null) {
            value = schema.newMessage();
        }
        this.references.add(value);
        ((ByteArrayInput)this.input).mergeObject(value, this);
        return value;
    }

    @Override
    public String getFieldName(int number) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFieldNumber(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInitialized(Object owner) {
        return true;
    }

    @Override
    public String messageFullName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String messageName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object newMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<? super Object> typeClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mergeFrom(Input input, Object message) throws IOException {
        Schema<Object> schema = this.lastSchema;
        schema.mergeFrom(this, message);
        if (!schema.isInitialized(message)) {
            throw new UninitializedMessageException(message, schema);
        }
        this.lastSchema = schema;
    }

    @Override
    public void writeTo(Output output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }
}

