/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.base.cache.ClientChannelCache;
import gate.base.cache.ProtocalStrategyCache;
import gate.base.chachequeue.CacheQueue;
import gate.client.Client2Master;
import gate.cluster.ZKFramework;
import gate.rpc.rpcProcessor.RPCProcessor;
import gate.rpc.rpcProcessor.RPCProcessorImpl;
import gate.server.Server4Terminal;
import gate.threadWorkers.MClient2Tmnl;
import gate.threadWorkers.TServer2MClient;
import gate.util.BannerUtil;
import gate.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class Entrance {
    public static CommandLine commandLine = null;
    public static int gatePort = 9811;
    public static String zkAddr = null;
    public static List<String> masterAddrs = new ArrayList<String>(1);
    public static CountDownLatch locks = new CountDownLatch(1);
    private static RPCProcessor processor = new RPCProcessorImpl();
    private static String[] protocolType;

    public static void main(String[] args) {
        boolean isCluster = Entrance.suitCommonLine(args);
        BannerUtil.info();
        System.setProperty("org.jboss.netty.epollBugWorkaround", "true");
        Entrance.initEnvriment();
        if (isCluster) {
            try {
                locks.await();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        } else {
            Entrance.startCli();
        }
        Entrance.startSev(protocolType);
        try {
            processor.exportService();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("rpc\u670d\u52a1\u53d1\u5e03\u5931\u8d25...............");
        }
        Entrance.addHook();
    }

    public static boolean suitCommonLine(String[] args) {
        commandLine = CommonUtil.parseCmdLine("iotGateServer", args, CommonUtil.buildCommandlineOptions(new Options()), new PosixParser());
        if (commandLine == null) {
            System.exit(-1);
        }
        boolean isCluster = false;
        if (commandLine.hasOption("c") && commandLine.hasOption("z")) {
            isCluster = true;
            zkAddr = commandLine.getOptionValue("z");
            new ZKFramework().start(zkAddr);
        } else if (commandLine.hasOption("m")) {
            String[] vals;
            String[] stringArray = vals = commandLine.getOptionValue("m").split("\\,");
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                masterAddrs.add(string);
                ++n2;
            }
        } else {
            System.err.println("\u542f\u52a8\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u542f\u52a8");
            System.exit(-1);
        }
        String confFile = commandLine.getOptionValue("f");
        protocolType = Entrance.getProtocolType(confFile);
        CommonUtil.gateNum = Integer.parseInt(commandLine.getOptionValue("n"));
        System.out.println(String.format("\u7f51\u5173\u7f16\u53f7\u4e3a\uff1a%s", CommonUtil.gateNum));
        if (commandLine.hasOption("p")) {
            gatePort = Integer.parseInt(commandLine.getOptionValue("p"));
        }
        return isCluster;
    }

    public static void initEnvriment() {
        try {
            new TServer2MClient(CacheQueue.up2MasterQueue, 1).start();
            new MClient2Tmnl(CacheQueue.down2TmnlQueue, 1).start();
        }
        catch (Exception e) {
            System.err.println("\u6570\u636e\u4e2d\u8f6c\u7ebf\u7a0b\u542f\u52a8\u5931\u8d25");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void addHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("\u7f51\u5173\u6b63\u5e38\u5173\u95ed\u524d\u6267\u884c  \u6e05\u7a7a\u6240\u6709\u7f13\u5b58\u4fe1\u606f...............................");
                ClientChannelCache.clearAll();
                CacheQueue.clearIpCountRelationCache();
                CacheQueue.clearMasterChannelCache();
            }
        }));
    }

    /*
     * Exception decompiling
     */
    public static String[] getProtocolType(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void startCli() {
        int i = 0;
        while (i < masterAddrs.size()) {
            final String addr = masterAddrs.get(i);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Client2Master client2Master = new Client2Master();
                        client2Master.bindAddress2Client(client2Master.configClient(addr, 8888, true));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
            }, "gate2masterThread_ip_" + addr).start();
            ++i;
        }
    }

    public static void startSev(String[] protocolType) {
        int i = 0;
        while (i < protocolType.length) {
            final String pts = protocolType[i];
            String pid = pts.split("\\,")[0];
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String[] pt = pts.split("\\,");
                    boolean isBigEndian = !"0".equals(pt[1]);
                    boolean isDataLenthIncludeLenthFieldLenth = !"0".equals(pt[5]);
                    System.out.println(String.format("\uff01\uff01\uff01\u7f51\u5173\u5f00\u59cb\u63d0\u4f9b\u89c4\u7ea6\u7c7b\u578b\u4e3a%s\u7684\u7ec8\u7aef\u8fde\u63a5\u670d\u52a1\uff0c\u5f00\u542f\u7aef\u53e3\u53f7\u4e3a\uff1a%s\uff0c\u5fc3\u8df3\u5468\u671f\u4e3a\uff1a%s S", Integer.parseInt(pt[0]), Integer.parseInt(pt[7]), Integer.parseInt(pt[8])));
                    Server4Terminal server4Terminal = new Server4Terminal(pt[0], pt[7]);
                    server4Terminal.bindAddress(server4Terminal.config(Integer.parseInt(pt[0]), isBigEndian, Integer.parseInt(pt[2]), Integer.parseInt(pt[3]), Integer.parseInt(pt[4]), isDataLenthIncludeLenthFieldLenth, Integer.parseInt(pt[6]), Integer.parseInt(pt[8])));
                }
            }, "gate2tmnlThread_pid_" + pid).start();
            ProtocalStrategyCache.protocalStrategyCache.put(pid, pts);
            ++i;
        }
    }
}

