/*
 * Decompiled with CFR 0.152.
 */
package gate.base.cache;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ClientChannelCache {
    private static List<ConcurrentHashMap<String, Channel>> cacheList = new ArrayList<ConcurrentHashMap<String, Channel>>();
    private static int scale = 16;

    static {
        ClientChannelCache.initClientChannelCache();
        System.out.println("GATE \u521d\u59cb\u5316ClientChannel\u7f13\u5b58\u5b8c\u6210......");
    }

    public static void initClientChannelCache() {
        int i = 0;
        while (i < scale) {
            cacheList.add(new ConcurrentHashMap());
            ++i;
        }
    }

    private static ConcurrentHashMap<String, Channel> getCacheInstance(String key) {
        int hashCode = key.hashCode();
        hashCode = hashCode < 0 ? -hashCode : hashCode;
        int index = hashCode % scale;
        return cacheList.get(index);
    }

    public static void set(String key, Channel value) {
        ClientChannelCache.getCacheInstance(key).put(key, value);
    }

    public static Channel get(String key) {
        return ClientChannelCache.getCacheInstance(key).get(key);
    }

    public static void removeOne(String key) {
        Channel channel = ClientChannelCache.getCacheInstance(key).remove(key);
        channel.closeFuture();
    }

    public static void clearAll() {
        for (ConcurrentHashMap<String, Channel> concurrentHashMap : cacheList) {
            concurrentHashMap.clear();
        }
    }

    private static void logOut(String msg) {
        int i = 0;
        while (i < cacheList.size()) {
            System.out.println("\u7f13\u5b58\u76d1\u63a7.............ClientChannelMap" + i + "==" + cacheList.get(i).size());
            ++i;
        }
    }
}

