/*
 * Decompiled with CFR 0.152.
 */
package gate.base.domain;

public class GateHeader {
    private boolean inBigEndian = false;
    private byte[] dataBuffer;
    private int pos = 0;
    private static final int INCREASE_DATA_SIZE = 30;

    public GateHeader() {
        this(30);
    }

    public GateHeader(int size) {
        this.dataBuffer = new byte[size];
    }

    public void writeInt8(byte data) throws Exception {
        this.ensureCapacity(this.pos + 1);
        this.dataBuffer[this.pos] = data;
        ++this.pos;
    }

    public void writeInt16(int i) throws Exception {
        this.ensureCapacity(this.pos + 2);
        if (this.inBigEndian) {
            this.dataBuffer[this.pos] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i & 0xFF);
        } else {
            this.dataBuffer[this.pos] = (byte)(i & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 8 & 0xFF);
        }
        this.pos += 2;
    }

    public void writeInt32(int i) throws Exception {
        this.ensureCapacity(this.pos + 4);
        if (this.inBigEndian) {
            this.dataBuffer[this.pos] = (byte)(i >>> 24 & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 16 & 0xFF);
            this.dataBuffer[this.pos + 2] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 3] = (byte)(i & 0xFF);
        } else {
            this.dataBuffer[this.pos] = (byte)(i & 0xFF);
            this.dataBuffer[this.pos + 1] = (byte)(i >>> 8 & 0xFF);
            this.dataBuffer[this.pos + 2] = (byte)(i >>> 16 & 0xFF);
            this.dataBuffer[this.pos + 3] = (byte)(i >>> 24 & 0xFF);
        }
        this.pos += 4;
    }

    public void writeInt64(long l) throws Exception {
        this.ensureCapacity(this.pos + 8);
        if (this.inBigEndian) {
            this.dataBuffer[this.pos] = (byte)(l >>> 56 & 0xFFL);
            this.dataBuffer[this.pos + 1] = (byte)(l >>> 48 & 0xFFL);
            this.dataBuffer[this.pos + 2] = (byte)(l >>> 40 & 0xFFL);
            this.dataBuffer[this.pos + 3] = (byte)(l >>> 32 & 0xFFL);
            this.dataBuffer[this.pos + 4] = (byte)(l >>> 24 & 0xFFL);
            this.dataBuffer[this.pos + 5] = (byte)(l >>> 16 & 0xFFL);
            this.dataBuffer[this.pos + 6] = (byte)(l >>> 8 & 0xFFL);
            this.dataBuffer[this.pos + 7] = (byte)(l & 0xFFL);
        } else {
            this.dataBuffer[this.pos] = (byte)(l & 0xFFL);
            this.dataBuffer[this.pos + 1] = (byte)(l >>> 8 & 0xFFL);
            this.dataBuffer[this.pos + 2] = (byte)(l >>> 16 & 0xFFL);
            this.dataBuffer[this.pos + 3] = (byte)(l >>> 24 & 0xFFL);
            this.dataBuffer[this.pos + 4] = (byte)(l >>> 32 & 0xFFL);
            this.dataBuffer[this.pos + 5] = (byte)(l >>> 40 & 0xFFL);
            this.dataBuffer[this.pos + 6] = (byte)(l >>> 48 & 0xFFL);
            this.dataBuffer[this.pos + 7] = (byte)(l >>> 56 & 0xFFL);
        }
        this.pos += 8;
    }

    public void ensureCapacity(int minCapacity) throws Exception {
        if (this.dataBuffer.length < minCapacity) {
            int nextBufSize = 30 * (minCapacity / 30 + 1);
            byte[] data = new byte[nextBufSize];
            System.arraycopy(this.dataBuffer, 0, data, 0, this.dataBuffer.length);
            this.dataBuffer = data;
        }
    }

    public boolean isInBigEndian() {
        return this.inBigEndian;
    }

    public void setInBigEndian(boolean inBigEndian) {
        this.inBigEndian = inBigEndian;
    }

    public byte[] getDataBuffer() {
        byte[] data = new byte[this.pos];
        System.arraycopy(this.dataBuffer, 0, data, 0, data.length);
        return data;
    }

    public void setDataBuffer(byte[] dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }
}

