/*
 * Decompiled with CFR 0.152.
 */
package gate.client;

import gate.base.cache.Cli2MasterLocalCache;
import gate.base.domain.GateHeader;
import gate.client.handler.Client2MasterInHandler;
import gate.client.handler.IOTGateWacthDog;
import gate.codec.Gate2MasterDecoderMult;
import gate.codec.Gate2MasterEncoderMult;
import gate.util.CommonUtil;
import gate.util.StringUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Client2Master {
    private EventLoopGroup worker = new NioEventLoopGroup();
    private Cli2MasterLocalCache cli2MasterLocalCache = Cli2MasterLocalCache.getInstance();
    private String ip;
    private int port;
    private DefaultEventExecutorGroup defaultEventExecutorGroup = new DefaultEventExecutorGroup(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
        private AtomicInteger threadIndex = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "NettyClientWorkerThread_" + this.threadIndex.incrementAndGet());
        }
    });

    public Bootstrap configClient(final String ip, final int port, final boolean isOpenWatchDog) {
        this.ip = ip;
        this.port = port;
        final Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.worker)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(0x2000000, 0x4000000))).option(ChannelOption.ALLOCATOR, UnpooledByteBufAllocator.DEFAULT)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new IOTGateWacthDog(bootstrap, ip, port, CommonUtil.wheelTimer, isOpenWatchDog){

                    @Override
                    public ChannelHandler[] getChannelHandlers() {
                        return new ChannelHandler[]{new Gate2MasterDecoderMult(), new Gate2MasterEncoderMult(), this, new Client2MasterInHandler()};
                    }

                    @Override
                    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                        ctx.fireChannelRead(msg);
                    }
                }.getChannelHandlers());
            }
        });
        return bootstrap;
    }

    public void bindAddress2Client(Bootstrap bootstrap) throws Exception {
        this.cli2MasterLocalCache.set(this.ip, this);
        ChannelFuture channelFuture = bootstrap.connect(this.ip, this.port).sync();
        Channel channel = channelFuture.channel();
        InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
        String ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
        ByteBuf buf = this.loginGateHeader(ipAddress);
        channelFuture.channel().writeAndFlush(buf);
        channelFuture.channel().closeFuture().sync();
    }

    public ByteBuf loginGateHeader(String LocalIpAddress) throws Exception {
        ByteBuf out = CommonUtil.getByteBuf();
        String ipAddress = LocalIpAddress;
        int count = 1;
        int len = 0;
        GateHeader headBuf = new GateHeader();
        headBuf.writeInt8(Integer.valueOf(171).byteValue());
        headBuf.writeInt32(len);
        headBuf.writeInt8(Integer.valueOf("03").byteValue());
        headBuf.writeInt8(Integer.valueOf("15").byteValue());
        headBuf.writeInt8((byte)CommonUtil.gateNum);
        int i = 0;
        while (i < 3) {
            headBuf.writeInt32(0);
            ++i;
        }
        byte[] bs = Inet4Address.getByName(ipAddress.split("\\|")[0]).getAddress();
        headBuf.writeInt8(bs[0]);
        headBuf.writeInt8(bs[1]);
        headBuf.writeInt8(bs[2]);
        headBuf.writeInt8(bs[3]);
        headBuf.writeInt16(Integer.parseInt(ipAddress.split("\\|")[1]));
        headBuf.writeInt32(count);
        out.writeBytes(headBuf.getDataBuffer());
        return out;
    }

    public void close() {
        CommonUtil.closeEventLoop(this.worker);
        this.cli2MasterLocalCache.del(this.ip);
    }
}

