/*
 * Decompiled with CFR 0.152.
 */
package gate.client.handler;

import gate.base.chachequeue.CacheQueue;
import gate.base.domain.ChannelData;
import gate.util.StringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler.Sharable
public class Client2MasterInHandler
extends SimpleChannelInboundHandler<Object> {
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof List) {
            List dataList = (List)msg;
            for (ChannelData channelData : dataList) {
                CacheQueue.down2TmnlQueue.put(channelData);
            }
        } else {
            ChannelData channelData = (ChannelData)msg;
            CacheQueue.down2TmnlQueue.put(channelData);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String ipAddress;
        super.channelActive(ctx);
        Channel channel = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
        String masterIP = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
        CacheQueue.addMasterChannel2LocalCache(masterIP, ctx.channel());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        Channel channel = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
        if (insocket != null) {
            String ipAddress;
            String masterIP = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
            CacheQueue.removeMasterChannelFromLocalCache(masterIP);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }
}

