/*
 * Decompiled with CFR 0.152.
 */
package gate.cluster;

import gate.Entrance;
import gate.base.cache.Cli2MasterLocalCache;
import gate.base.cache.ZKMasterNodeLocalCache;
import gate.base.domain.LocalCache;
import gate.client.Client2Master;
import gate.concurrent.BasicThreadPoolTaskExecutor;
import gate.concurrent.ThreadFactoryImpl;
import gate.util.MixAll;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;

public class ZKFramework {
    private ExecutorService basicTaskExecutor = BasicThreadPoolTaskExecutor.getBasicExecutor();
    private Cli2MasterLocalCache cli2MasterLocalCache = Cli2MasterLocalCache.getInstance();
    private CuratorFramework cf;
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryImpl("zkNodeCacheUpdate_", true));
    private final String PARENT_PATH = "/iotGate2Master";
    LocalCache zkNodeCache = ZKMasterNodeLocalCache.getInstance();

    public void init(String zkAddr) {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 10);
        this.cf = CuratorFrameworkFactory.builder().connectString(zkAddr).sessionTimeoutMs(6000).retryPolicy(retryPolicy).build();
        System.out.println("zk\u8fde\u63a5\u4e2d\u3002\u3002\u3002\u3002\u3002\u3002");
        this.cf.start();
        while (this.cf.getState() != CuratorFrameworkState.STARTED) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("zk\u8fde\u63a5\u6210\u529f\uff0c\u5f00\u59cb\u6ce8\u518c\u8282\u70b9\u4fe1\u606f\u3002\u3002\u3002\u3002\u3002");
        try {
            this.zNodeListener();
            this.addGateNode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zNodeListener() throws Exception {
        if (this.cf.checkExists().forPath("/iotGate2Master") == null) {
            ((ACLBackgroundPathAndBytesable)this.cf.create().withMode(CreateMode.PERSISTENT)).forPath("/iotGate2Master", "pastoralDog init".getBytes());
        }
        PathChildrenCache cache = new PathChildrenCache(this.cf, "/iotGate2Master", true);
        cache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        cache.getListenable().addListener(new PathChildrenCacheListener(){

            @Override
            public void childEvent(CuratorFramework cf, PathChildrenCacheEvent event) throws Exception {
                switch (event.getType()) {
                    case CHILD_ADDED: {
                        System.out.println("CHILD_ADDED :" + event.getData().getPath());
                        try {
                            String val = new String(event.getData().getData());
                            ZKFramework.this.link2MasterNode(val);
                            ZKFramework.this.addNode2Cache(val);
                            Entrance.locks.countDown();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case CHILD_UPDATED: {
                        System.out.println("CHILD_UPDATED :" + event.getData().getPath());
                        System.out.println("DATA :" + new String(event.getData().getData()));
                        break;
                    }
                    case CHILD_REMOVED: {
                        System.out.println("CHILD_REMOVED :" + event.getData().getPath());
                        String ip = new String(event.getData().getData());
                        try {
                            ZKFramework.this.delNode2Cache(ip);
                            Client2Master client2Master = (Client2Master)ZKFramework.this.cli2MasterLocalCache.get(ip);
                            client2Master.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
    }

    private boolean isCluster() {
        return true;
    }

    @Deprecated
    private void downloadData2LocalCache() throws Exception {
        this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> dataList = null;
                try {
                    List pathList = (List)ZKFramework.this.cf.getChildren().forPath("/iotgate");
                    dataList = new ArrayList<String>();
                    for (String string : pathList) {
                        String data = new String((byte[])ZKFramework.this.cf.getData().forPath("/iotgate/c1"));
                        dataList.add(data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void addGateNode() {
        try {
            String addr = MixAll.linuxLocalIP();
            ((ACLBackgroundPathAndBytesable)this.cf.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath("/iotGate2RPC/" + addr, addr.getBytes());
            System.out.println("********zookeeper\u6ce8\u518cGATE\u4fe1\u606f\u6210\u529f\uff01********");
        }
        catch (Exception e) {
            System.err.println("zookeeper\u6ce8\u518cGATE\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void addNode2Cache(String nodeIp) throws Exception {
        if (this.zkNodeCache.get(nodeIp) == null) {
            this.zkNodeCache.set(nodeIp, nodeIp);
        }
    }

    private void updateNode2Cache(String nodeIp) throws Exception {
    }

    private void delNode2Cache(String nodeIp) throws Exception {
        if (this.zkNodeCache.get(nodeIp) == null) {
            return;
        }
        this.zkNodeCache.del(nodeIp);
    }

    private void link2MasterNode(final String addr) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println(String.format("\uff01\uff01\uff01\u524d\u7f6e\u670d\u52a1%s\u8fde\u63a5\u6210\u529f,\u524d\u7f6e\u7aef\u53e3\u5fc5\u987b\u4e3a8888", addr));
                    Client2Master client2Master = new Client2Master();
                    client2Master.bindAddress2Client(client2Master.configClient(addr, 8888, false));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "gate2masterThread_ip_" + addr).start();
    }

    public void start(final String zkAddr) {
        if (this.isCluster()) {
            this.basicTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZKFramework.this.init(zkAddr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            System.out.println("********\u5f53\u524d\u524d\u7f6e\u88ab\u6307\u5b9a\u4e3a\u5355\u673a\u7248\uff0c\u65e0\u9700\u6ce8\u518c\u8282\u70b9\u4fe1\u606f\u5230zookeeper********");
        }
    }
}

