/*
 * Decompiled with CFR 0.152.
 */
package gate.codec;

import gate.base.domain.ChannelData;
import gate.base.domain.SocketData;
import gate.util.CommonUtil;
import gate.util.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.internal.RecyclableArrayList;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class Gate2ClientDecoderMulti
extends ByteToMessageDecoder {
    private int pId;
    private boolean isBigEndian;
    private int beginHexVal;
    private int lengthFieldOffset;
    private int lengthFieldLength;
    private boolean isDataLenthIncludeLenthFieldLenth;
    private int exceptDataLenth;
    private int initialBytesToStrip;

    public Gate2ClientDecoderMulti(int pId, boolean isBigEndian, int beginHexVal, int lengthFieldOffset, int lengthFieldLength, boolean isDataLenthIncludeLenthFieldLenth, int exceptDataLenth, int initialBytesToStrip) {
        this.pId = pId;
        this.isBigEndian = isBigEndian;
        this.beginHexVal = beginHexVal;
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.isDataLenthIncludeLenthFieldLenth = isDataLenthIncludeLenthFieldLenth;
        this.exceptDataLenth = exceptDataLenth;
        this.initialBytesToStrip = initialBytesToStrip;
    }

    public Gate2ClientDecoderMulti(int pId, boolean isBigEndian, int beginHexVal, int lengthFieldOffset, int lengthFieldLength, boolean isDataLenthIncludeLenthFieldLenth, int exceptDataLenth) {
        this(pId, isBigEndian, beginHexVal, lengthFieldOffset, lengthFieldLength, isDataLenthIncludeLenthFieldLenth, exceptDataLenth, 0);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        block31: {
            int baseLen = this.lengthFieldOffset + this.lengthFieldLength + this.exceptDataLenth + this.initialBytesToStrip;
            if (in.readableBytes() >= baseLen) {
                RecyclableArrayList arrayList = RecyclableArrayList.newInstance();
                while (in.readableBytes() >= baseLen) {
                    ChannelData channelData;
                    SocketData data;
                    String clientIpAddress;
                    String ipAddress;
                    InetSocketAddress insocket;
                    Channel channel;
                    int lenVal;
                    ByteBuf lenAre;
                    int beginReader = in.readerIndex();
                    ByteBuf byteBuf = CommonUtil.getByteBuf();
                    if (this.initialBytesToStrip == 0) {
                        int i = 0;
                        while (i < this.lengthFieldOffset) {
                            byteBuf.writeByte(in.readByte());
                            ++i;
                        }
                        lenAre = in.readBytes(this.lengthFieldLength);
                        lenVal = 0;
                        switch (this.lengthFieldLength) {
                            case 1: {
                                lenVal = lenAre.readByte() & 0xFF;
                                break;
                            }
                            case 2: {
                                if (this.isBigEndian) {
                                    lenVal = lenAre.readShort();
                                    break;
                                }
                                lenVal = lenAre.readShortLE();
                                break;
                            }
                            case 4: {
                                if (this.isBigEndian) {
                                    lenVal = lenAre.readInt();
                                    break;
                                }
                                lenVal = lenAre.readIntLE();
                                break;
                            }
                            default: {
                                CommonUtil.releaseByteBuf(byteBuf);
                            }
                        }
                        lenAre.readerIndex(0);
                        byteBuf.writeBytes(lenAre);
                        if (this.isDataLenthIncludeLenthFieldLenth) {
                            lenVal -= this.lengthFieldLength;
                        }
                        if (in.readableBytes() >= lenVal + this.exceptDataLenth && lenVal > 0) {
                            int i2 = 0;
                            while (i2 < lenVal + this.exceptDataLenth) {
                                byteBuf.writeByte(in.readByte());
                                ++i2;
                            }
                            channel = ctx.channel();
                            insocket = (InetSocketAddress)channel.remoteAddress();
                            clientIpAddress = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
                            data = new SocketData(byteBuf);
                            data.setpId(this.pId);
                            channelData = new ChannelData(clientIpAddress, data);
                            arrayList.add(channelData);
                            continue;
                        }
                        in.readerIndex(beginReader + 1);
                        CommonUtil.releaseByteBuf(byteBuf);
                    } else {
                        int i = 0;
                        while (i < this.initialBytesToStrip) {
                            byteBuf.writeByte(in.readByte());
                            ++i;
                        }
                        i = 0;
                        while (i < this.lengthFieldOffset) {
                            byteBuf.writeByte(in.readByte());
                            ++i;
                        }
                        lenAre = in.readBytes(this.lengthFieldLength);
                        lenVal = 0;
                        switch (this.lengthFieldLength) {
                            case 1: {
                                lenVal = lenAre.readByte() & 0xFF;
                                break;
                            }
                            case 2: {
                                if (this.isBigEndian) {
                                    lenVal = lenAre.readShort();
                                    break;
                                }
                                lenVal = lenAre.readShortLE();
                                break;
                            }
                            case 4: {
                                if (this.isBigEndian) {
                                    lenVal = lenAre.readInt();
                                    break;
                                }
                                lenVal = lenAre.readIntLE();
                                break;
                            }
                            default: {
                                CommonUtil.releaseByteBuf(byteBuf);
                            }
                        }
                        lenAre.readerIndex(0);
                        byteBuf.writeBytes(lenAre);
                        if (this.isDataLenthIncludeLenthFieldLenth) {
                            lenVal -= this.lengthFieldLength;
                        }
                        if (in.readableBytes() >= lenVal + this.exceptDataLenth && lenVal > 0) {
                            int i3 = 0;
                            while (i3 < lenVal + this.exceptDataLenth) {
                                byteBuf.writeByte(in.readByte());
                                ++i3;
                            }
                            channel = ctx.channel();
                            insocket = (InetSocketAddress)channel.remoteAddress();
                            clientIpAddress = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
                            data = new SocketData(byteBuf);
                            data.setpId(this.pId);
                            channelData = new ChannelData(clientIpAddress, data);
                            arrayList.add(channelData);
                            continue;
                        }
                        in.readerIndex(beginReader + 1);
                        CommonUtil.releaseByteBuf(byteBuf);
                    }
                    break block31;
                }
                int size = arrayList.size();
                if (size == 1) {
                    out.add(arrayList.get(0));
                } else if (size > 1) {
                    ArrayList arrayList2 = new ArrayList(size);
                    int i = 0;
                    while (i < size) {
                        arrayList2.add(arrayList.get(i));
                        ++i;
                    }
                    out.add(arrayList2);
                }
                arrayList.recycle();
            }
        }
    }
}

