/*
 * Decompiled with CFR 0.152.
 */
package gate.codec;

import gate.base.domain.ChannelData;
import gate.base.domain.SocketData;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.List;

public class Gate2MasterDecoderMult
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() > 31) {
            while (in.readableBytes() > 31) {
                int beginReader = in.readerIndex();
                int gateHeader = in.readByte() & 0xFF;
                if (gateHeader == 171) {
                    int socketDataLen = in.readIntLE();
                    if (in.readableBytes() >= socketDataLen + 25) {
                        in.skipBytes(1);
                        boolean isIPV4 = true;
                        int pId = -1;
                        int sig = in.readByte() & 0xFF;
                        pId = sig & 0x7F;
                        int type = sig >> 7 & 1;
                        isIPV4 = type == 0;
                        StringBuilder clientIpAddress = new StringBuilder();
                        if (isIPV4) {
                            in.skipBytes(13);
                            clientIpAddress.append(in.readByte() & 0xFF);
                            clientIpAddress.append(".");
                            clientIpAddress.append(in.readByte() & 0xFF);
                            clientIpAddress.append(".");
                            clientIpAddress.append(in.readByte() & 0xFF);
                            clientIpAddress.append(".");
                            clientIpAddress.append(in.readByte() & 0xFF);
                        } else {
                            in.skipBytes(1);
                            byte[] dataTemp = new byte[16];
                            int i = 0;
                            while (i < 16) {
                                dataTemp[i] = in.readByte();
                                ++i;
                            }
                            try {
                                clientIpAddress.append(Inet6Address.getByAddress(dataTemp).getHostAddress());
                            }
                            catch (UnknownHostException e) {
                                e.printStackTrace();
                            }
                        }
                        clientIpAddress.append("|");
                        clientIpAddress.append(in.readShortLE() & 0xFFFF);
                        in.skipBytes(4);
                        SocketData data = new SocketData(in.readBytes(socketDataLen));
                        data.setpId(pId);
                        ChannelData channelData = new ChannelData(data);
                        channelData.setIpAddress(clientIpAddress.toString());
                        out.add(channelData);
                        continue;
                    }
                    in.readerIndex(beginReader);
                    break;
                }
                if (in.readableBytes() > 31) continue;
            }
        }
    }
}

