/*
 * Decompiled with CFR 0.152.
 */
package gate.remoting;

import gate.codec.RpcDecoder;
import gate.codec.RpcEncoder;
import gate.concurrent.ThreadFactoryImpl;
import gate.rpc.dataBridge.RequestData;
import gate.rpc.dataBridge.ResponseData;
import gate.rpc.rpcProcessor.RPCProcessor;
import gate.rpc.rpcProcessor.RPCProcessorImpl;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;

public class RemoteServer {
    private final ServerBootstrap bootstrap;
    private final EventLoopGroup eventLoopGroupWorker;
    private final EventLoopGroup eventLoopGroupBoss;
    RPCProcessor processor = new RPCProcessorImpl();

    public RemoteServer() {
        this.bootstrap = new ServerBootstrap();
        this.eventLoopGroupBoss = new NioEventLoopGroup(1);
        this.eventLoopGroupWorker = new NioEventLoopGroup(2, new ThreadFactoryImpl("netty_RPC_selecter_", false));
    }

    public void start() {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupWorker).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_KEEPALIVE, false)).childOption(ChannelOption.TCP_NODELAY, true).option(ChannelOption.SO_SNDBUF, 65535)).option(ChannelOption.SO_RCVBUF, 65535)).localAddress(new InetSocketAddress(10916))).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new RpcEncoder(), new RpcDecoder(), new IdleStateHandler(0, 0, 120), new NettyConnetManageHandler(), new NettyServerHandler());
            }
        });
        try {
            ChannelFuture sync = this.bootstrap.bind().sync();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)sync.channel().localAddress();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("this.bootstrap.bind().sync() InterruptedException", e1);
        }
    }

    class NettyConnetManageHandler
    extends ChannelDuplexHandler {
        NettyConnetManageHandler() {
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            super.channelRegistered(ctx);
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            super.channelUnregistered(ctx);
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent evnet;
            if (evt instanceof IdleStateEvent && (evnet = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                ctx.channel().close();
            }
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.channel().close();
        }
    }

    class NettyServerHandler
    extends SimpleChannelInboundHandler<RequestData> {
        NettyServerHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, RequestData msg) throws Exception {
            ResponseData rsp = RemoteServer.this.processor.executeService(msg);
            ctx.channel().writeAndFlush(rsp);
        }
    }
}

