/*
 * Decompiled with CFR 0.152.
 */
package gate.rpc.rpcProcessor;

import gate.base.cache.RPCCache;
import gate.remoting.RemoteServer;
import gate.rpc.annotation.RPCService;
import gate.rpc.dataBridge.RequestData;
import gate.rpc.dataBridge.ResponseData;
import gate.rpc.rpcProcessor.RPCProcessor;
import gate.util.MixAll;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class RPCProcessorImpl
implements RPCProcessor {
    @Override
    public void exportService() throws Exception {
        List<String> result = MixAll.getClazzName("gate.rpc.rpcService", false);
        for (String className : result) {
            Class<?> clazz = Class.forName(className);
            if (!clazz.isAnnotationPresent(RPCService.class)) continue;
            RPCCache.putClass(clazz.getSimpleName(), clazz);
        }
        new RemoteServer().start();
        System.out.println("\u53d1\u5e03rpc\u670d\u52a1\u5b8c\u6bd5........");
    }

    @Override
    public ResponseData executeService(RequestData requestData) {
        Class<?> clazz = RPCCache.getClass(String.valueOf(requestData.getClassName()) + "Impl");
        ResponseData responseData = null;
        try {
            Method method = clazz.getMethod(requestData.getMethodName(), requestData.getParamTyps());
            responseData = (ResponseData)method.invoke(clazz.newInstance(), requestData.getArgs());
            responseData.setResponseNum(requestData.getRequestNum());
            return responseData;
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        responseData = new ResponseData();
        responseData.setResponseNum(requestData.getRequestNum());
        return null;
    }
}

