/*
 * Decompiled with CFR 0.152.
 */
package gate.server;

import gate.base.cache.ProtocalStrategyCache;
import gate.codec.Gate2ClientDecoderMulti;
import gate.codec.Gate2ClientEncoderMulti;
import gate.server.handler.SocketInHandler;
import gate.util.CommonUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Server4Terminal {
    private String pId;
    private String serverPort;
    private EventLoopGroup boss;
    private EventLoopGroup work;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;

    public Server4Terminal(String pId, String serverPort) {
        this.pId = pId;
        this.serverPort = serverPort;
        this.boss = new NioEventLoopGroup(1);
        this.work = new NioEventLoopGroup();
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyServerWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
    }

    public ServerBootstrap config(final int pId, final boolean isBigEndian, final int beginHexVal, final int lengthFieldOffset, final int lengthFieldLength, final boolean isDataLenthIncludeLenthFieldLenth, final int exceptDataLenth, final int heartbeat) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.boss, this.work).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.ALLOCATOR, UnpooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, UnpooledByteBufAllocator.DEFAULT).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new IdleStateHandler(0L, 0L, heartbeat, TimeUnit.SECONDS));
                ch.pipeline().addLast("decoder", (ChannelHandler)new Gate2ClientDecoderMulti(pId, isBigEndian, beginHexVal, lengthFieldOffset, lengthFieldLength, isDataLenthIncludeLenthFieldLenth, exceptDataLenth));
                ch.pipeline().addLast("encoder", (ChannelHandler)new Gate2ClientEncoderMulti());
                ch.pipeline().addLast(new SocketInHandler());
            }
        });
        return serverBootstrap;
    }

    public void bindAddress(ServerBootstrap serverBootstrap) {
        block5: {
            try {
                try {
                    ProtocalStrategyCache.protocalServerCache.put(this.pId, this);
                    ChannelFuture channelFuture = serverBootstrap.bind(Integer.parseInt(this.serverPort)).sync();
                    System.out.println("\u7f51\u5173\u670d\u52a1\u7aef\u5df2\u542f\u52a8\uff01\uff01");
                    channelFuture.channel().closeFuture().sync();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    CommonUtil.closeEventLoop(this.boss, this.work);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.closeEventLoop(this.boss, this.work);
                throw throwable;
            }
            CommonUtil.closeEventLoop(this.boss, this.work);
        }
    }

    public void close() {
        CommonUtil.closeEventLoop(this.boss, this.work);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ProtocalStrategyCache.protocalServerCache.remove(this.pId);
    }
}

