/*
 * Decompiled with CFR 0.152.
 */
package gate.server.handler;

import gate.base.cache.ClientChannelCache;
import gate.base.chachequeue.CacheQueue;
import gate.base.domain.ChannelData;
import gate.util.StringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.util.List;
import test.CountHelper;

@ChannelHandler.Sharable
public class SocketInHandler
extends ChannelInboundHandlerAdapter {
    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String ipAddress;
        super.channelActive(ctx);
        Channel channel = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
        String clientIpAddress = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
        Integer count = CacheQueue.ipCountRelationCache.get(clientIpAddress);
        if (count != null && count < 10000) {
            CacheQueue.ipCountRelationCache.put(clientIpAddress, count + 1);
        } else {
            CacheQueue.ipCountRelationCache.put(clientIpAddress, 1);
        }
        ClientChannelCache.set(clientIpAddress, channel);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String ipAddress;
        super.channelInactive(ctx);
        Channel channel = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
        String clientIpAddress = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
        ClientChannelCache.removeOne(clientIpAddress);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (msg instanceof List) {
                List lists = (List)msg;
                for (ChannelData channelData : lists) {
                    CacheQueue.up2MasterQueue.put(channelData);
                    this.analyse();
                }
            } else {
                ChannelData channelData = (ChannelData)msg;
                CacheQueue.up2MasterQueue.put(channelData);
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String ipAddress;
        super.exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
        String clientIpAddress = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
        ClientChannelCache.removeOne(clientIpAddress);
        cause.printStackTrace();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            if (state == IdleState.READER_IDLE) {
                ChannelFuture fcutrue = ctx.close();
                fcutrue.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        String ipAddress;
                        Channel channel = future.channel();
                        InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
                        String key = ipAddress = StringUtils.formatIpAddress(insocket.getHostName(), String.valueOf(insocket.getPort()));
                        System.out.println(String.valueOf(key) + "\u5fc3\u8df3\u8d85\u65f6\u4e0b\u7ebf\u6210\u529f....");
                    }
                });
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void analyse() {
        if (CountHelper.startTimeLong.get() == 0L) {
            Class<CountHelper> clazz = CountHelper.class;
            // MONITORENTER : test.CountHelper.class
            if (CountHelper.startTimeLong.get() == 0L) {
                CountHelper.startTimeLong.set(System.currentTimeMillis());
            }
            // MONITOREXIT : clazz
        }
        CountHelper.clientRecieveCount.addAndGet(1);
        long curNum = CountHelper.clientRecieveCount.get();
        if (curNum % 1000L != 0L) return;
        System.out.println(String.valueOf(curNum) + "\u82b1\u8d39\u4e86\uff1a" + (System.currentTimeMillis() - CountHelper.startTimeLong.get()));
    }
}

