/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommonUtil {
    public static int gateNum;
    private static UnpooledByteBufAllocator allocator;
    public static AtomicInteger recieveCount;
    public static HashedWheelTimer wheelTimer;
    public static final String OS_NAME;
    private static boolean isLinuxPlatform;
    private static boolean isWindowsPlatform;

    static {
        wheelTimer = new HashedWheelTimer();
        OS_NAME = System.getProperty("os.name");
        isLinuxPlatform = false;
        isWindowsPlatform = false;
        recieveCount = new AtomicInteger(0);
        allocator = UnpooledByteBufAllocator.DEFAULT;
        if (OS_NAME != null && OS_NAME.toLowerCase().indexOf("linux") >= 0) {
            isLinuxPlatform = true;
        }
        if (OS_NAME != null && OS_NAME.toLowerCase().indexOf("windows") >= 0) {
            isWindowsPlatform = true;
        }
    }

    public static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    public static ByteBuf getByteBuf() {
        return allocator.heapBuffer();
    }

    public static void releaseByteBuf(ByteBuf buf) {
        if (buf != null) {
            ReferenceCountUtil.release(buf);
        }
    }

    public static void closeEventLoop(EventLoopGroup ... group) {
        EventLoopGroup[] eventLoopGroupArray = group;
        int n = group.length;
        int n2 = 0;
        while (n2 < n) {
            EventLoopGroup eventLoopGroup = eventLoopGroupArray[n2];
            eventLoopGroup.shutdownGracefully();
            ++n2;
        }
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("n", true, "gate num");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("c", false, "open Cluster");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("z", true, "zk address list, eg: 192.168.18.27:2181,192.168.18.27:2182,192.168.18.27:2183");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", true, "master addr, eg 127.0.0.1,127.0.0.1");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("f", true, "cache file url: eg win:'D:\\iotGate.conf'  ; linux: '/gate/iotGate.conf'");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("h", false, "help info");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static CommandLine parseCmdLine(String appName, String[] args, Options options, CommandLineParser parser) {
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(110);
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                hf.printHelp(appName, options, true);
                return null;
            }
        }
        catch (ParseException e) {
            hf.printHelp(appName, options, true);
        }
        return commandLine;
    }
}

