/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemClassLoader
extends ClassLoader {
    String dirRoot = null;

    public FileSystemClassLoader(String dirRoot) {
        this.dirRoot = dirRoot;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = super.loadClass(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        byte[] bytes = this.getBytesByName(name);
        clazz = this.defineClass(name, bytes, 0, bytes.length);
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    public byte[] getBytesByName(String name) {
        String path = String.valueOf(this.dirRoot) + File.separator + name.replace(".", "/") + ".class";
        FileInputStream is = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            is = new FileInputStream(path);
            byte[] buffer = new byte[1024];
            int temp = 0;
            while ((temp = ((InputStream)is).read(buffer)) != -1) {
                baos.write(buffer, 0, temp);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

