/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class MixAll {
    private static final String CLASS_SUFFIX = ".class";
    private static final String CLASS_FILE_PREFIX = String.valueOf(File.separator) + "classes" + File.separator;
    private static final String PACKAGE_SEPARATOR = ".";
    public static List<String> inetAddressList = MixAll.getLocalInetAddress();

    private MixAll() {
        throw new AssertionError();
    }

    public static List<String> getLocalInetAddress() {
        ArrayList<String> inetAddressList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    inetAddressList.add(addrs.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("get local inet address fail", e);
        }
        return inetAddressList;
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (processName != null && processName.length() > 0) {
            try {
                return Long.parseLong(processName.split("@")[0]);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static String localhostName() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Throwable e) {
            throw new RuntimeException("InetAddress java.net.InetAddress.getLocalHost() throws UnknownHostException", e);
        }
    }

    public static String linuxLocalIP() throws SocketException {
        Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress ip = null;
        String localHostIP = null;
        ArrayList<InetAddress> cache = new ArrayList<InetAddress>();
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ip = addresses.nextElement();
                if (ip != null && ip instanceof Inet4Address) {
                    if (!ip.isLoopbackAddress() && ip.isSiteLocalAddress()) {
                        localHostIP = ip.getHostAddress();
                        System.out.println("\u672c\u673a\u7684IPV4 = " + ip.getHostAddress());
                        continue;
                    }
                    cache.add(ip);
                    continue;
                }
                if (!(ip instanceof Inet6Address)) continue;
                if (!ip.isLoopbackAddress() && ip.isSiteLocalAddress()) {
                    localHostIP = ip.getHostAddress();
                    continue;
                }
                cache.add(ip);
            }
        }
        if (localHostIP != null) {
            return localHostIP;
        }
        for (InetAddress inetAddress : cache) {
            if (!inetAddress.isSiteLocalAddress()) continue;
            System.out.println("\u53bb\u672c\u5730\u5730\u5740ip=" + inetAddress.getHostAddress());
            return inetAddress.getHostAddress();
        }
        return null;
    }

    public static List<String> getClazzName(String packageName, boolean showChildPackageFlag) {
        ArrayList<String> result = new ArrayList<String>();
        String suffixPath = packageName.replaceAll("\\.", "\\/");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = loader.getResources(suffixPath);
            while (urls.hasMoreElements()) {
                String protocol;
                URL url = urls.nextElement();
                if (url == null || !"file".equals(protocol = url.getProtocol())) continue;
                String path = url.getPath();
                System.out.println(path);
                result.addAll(MixAll.getAllClassNameByFile(new File(path), showChildPackageFlag));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static List<String> getAllClassNameByFile(File file, boolean flag) {
        ArrayList<String> result = new ArrayList<String>();
        if (!file.exists()) {
            return result;
        }
        if (file.isFile()) {
            String clazzName;
            String path = file.getPath();
            if (path.endsWith(CLASS_SUFFIX) && -1 == (clazzName = (path = path.replace(CLASS_SUFFIX, "")).substring(path.indexOf(CLASS_FILE_PREFIX) + CLASS_FILE_PREFIX.length()).replace(File.separator, PACKAGE_SEPARATOR)).indexOf("$")) {
                result.add(clazzName);
            }
            return result;
        }
        File[] listFiles = file.listFiles();
        if (listFiles != null && listFiles.length > 0) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String clazzName;
                String path;
                File f = fileArray[n2];
                if (flag) {
                    result.addAll(MixAll.getAllClassNameByFile(f, flag));
                } else if (f.isFile() && (path = f.getPath()).endsWith(CLASS_SUFFIX) && -1 == (clazzName = (path = path.replace(CLASS_SUFFIX, "")).substring(path.indexOf(CLASS_FILE_PREFIX) + CLASS_FILE_PREFIX.length()).replace(File.separator, PACKAGE_SEPARATOR)).indexOf("$")) {
                    result.add(clazzName);
                }
                ++n2;
            }
        }
        return result;
    }

    public static <T> T decode(byte[] data, Class<T> classOfT) {
        String json = new String(data, Charset.forName("UTF-8"));
        try {
            T t = JSON.parseObject(json, classOfT);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encode(Object obj) {
        String json = JSON.toJSONString(obj, false);
        if (json != null) {
            return json.getBytes(Charset.forName("UTF-8"));
        }
        return null;
    }
}

