/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;

public class StringUtils {
    private static Random randGen = new Random();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] upcaseHexChar = "0123456789ABCDEF".toCharArray();
    private static final char[] lowerHexChar = "0123456789abcdef".toCharArray();
    private static int[] hexCharCodes = new int[256];
    private static int[] base64Codes = new int[256];
    private static SimpleDateFormat m_ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    static {
        int i = 0;
        while (i < 256) {
            int tmp128_127;
            StringUtils.base64Codes[i] = tmp128_127 = -1;
            StringUtils.hexCharCodes[i] = tmp128_127;
            ++i;
        }
        i = 0;
        while (i < base64Chars.length) {
            StringUtils.base64Codes[StringUtils.base64Chars[i]] = (byte)i;
            ++i;
        }
        i = 0;
        while (i < upcaseHexChar.length) {
            StringUtils.hexCharCodes[StringUtils.upcaseHexChar[i]] = (byte)i;
            ++i;
        }
        i = 0;
        while (i < lowerHexChar.length) {
            StringUtils.hexCharCodes[StringUtils.lowerHexChar[i]] = (byte)i;
            ++i;
        }
    }

    public static String getCurrTime() {
        Date now = new Date();
        SimpleDateFormat outFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = outFormat.format(now);
        return s;
    }

    public static String getCurrTimeISO8601(Date date) {
        if (date == null) {
            date = new Date();
        }
        String dateStr = m_ISO8601Local.format(date);
        return String.valueOf(dateStr.substring(0, 22)) + ":" + dateStr.substring(22);
    }

    public static int getStrIndex(String s, String[] args) {
        int length = args.length;
        int i = 0;
        while (i < length) {
            if (args[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final String replace(String line, String oldString, String newString) {
        return StringUtils.replace(line, oldString, newString, false);
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString) {
        return StringUtils.replace(line, oldString, newString, true);
    }

    public static final String replace(String line, String oldString, String newString, boolean ignoreCase) {
        if (line == null || oldString == null || newString == null) {
            return null;
        }
        String lcLine = line;
        String lcOldString = oldString;
        if (ignoreCase) {
            lcLine = line.toLowerCase();
            lcOldString = oldString.toLowerCase();
        }
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, i, line2.length - i);
            return buf.toString();
        }
        return line;
    }

    public static final String encodeHex(byte[] bytes) {
        return StringUtils.encodeHex(bytes, true);
    }

    public static final String encodeHex(byte[] bytes, boolean isUpper) {
        char[] hexChar = isUpper ? upcaseHexChar : lowerHexChar;
        char[] buf = new char[bytes.length * 2];
        return StringUtils.encodeHex(bytes, buf, hexChar, 0, bytes.length);
    }

    public static final String encodeHex(byte[] bytes, char[] buf, int offset, int length) {
        return StringUtils.encodeHex(bytes, buf, upcaseHexChar, offset, length);
    }

    public static final String encodeHex(byte[] bytes, char[] buf, char[] hexChar, int offset, int length) {
        int i = 0;
        while (i < length) {
            int code = bytes[i + offset] & 0xFF;
            buf[2 * i] = hexChar[code >> 4];
            buf[2 * i + 1] = hexChar[code & 0xF];
            ++i;
        }
        return new String(buf, 0, length * 2);
    }

    public static final String dumpHex(byte[] bytes) {
        int linecount = (bytes.length + 15) / 16;
        char[] buf = new char[linecount * 56];
        byte[] bs = new byte[16];
        int bytepos = 0;
        int bufpos = 0;
        int i = 0;
        while (i < linecount) {
            int addr = i * 16;
            buf[bufpos++] = upcaseHexChar[addr >> 12 & 0xF];
            buf[bufpos++] = upcaseHexChar[addr >> 8 & 0xF];
            buf[bufpos++] = upcaseHexChar[addr >> 4 & 0xF];
            buf[bufpos++] = upcaseHexChar[addr & 0xF];
            buf[bufpos++] = 32;
            buf[bufpos++] = 32;
            int j = 0;
            while (j < 16) {
                if (bytepos < bytes.length) {
                    int code = bytes[bytepos] & 0xFF;
                    bs[j] = bytes[bytepos];
                    buf[bufpos++] = upcaseHexChar[code >> 4];
                    buf[bufpos++] = upcaseHexChar[code & 0xF];
                    buf[bufpos++] = j == 7 ? 45 : 32;
                } else {
                    buf[bufpos++] = 32;
                    buf[bufpos++] = 32;
                    buf[bufpos++] = 32;
                    bs[j] = 32;
                }
                ++j;
                ++bytepos;
            }
            buf[bufpos++] = 13;
            buf[bufpos++] = 10;
            ++i;
        }
        return new String(buf, 0, bufpos);
    }

    public static final byte[] decodeHex(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        StringUtils.decodeHex(hex, bytes);
        return bytes;
    }

    public static final int decodeHex(String hex, byte[] bytes) {
        int byteCount = 0;
        int length = hex.length();
        int i = 0;
        while (i < length) {
            int newByte = 0;
            newByte = (byte)(newByte | hexCharCodes[hex.charAt(i)]);
            newByte = (byte)(newByte << 4);
            bytes[byteCount] = newByte = (int)((byte)(newByte | hexCharCodes[hex.charAt(i + 1)]));
            ++byteCount;
            i += 2;
        }
        return byteCount;
    }

    public static String encodeBase64(String data) {
        return StringUtils.encodeBase64(data.getBytes());
    }

    public static String encodeBase64(byte[] data, boolean lineBreak) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        char[] buf = new char[(len / 3 + 1) * 4 + len / 57 + 1];
        int pos = 0;
        int i = 0;
        while (i < len) {
            int c = data[i] >> 2 & 0x3F;
            buf[pos++] = base64Chars[c];
            c = data[i] << 4 & 0x3F;
            if (++i < len) {
                c |= data[i] >> 4 & 0xF;
            }
            buf[pos++] = base64Chars[c];
            if (i < len) {
                c = data[i] << 2 & 0x3F;
                if (++i < len) {
                    c |= data[i] >> 6 & 3;
                }
                buf[pos++] = base64Chars[c];
            } else {
                ++i;
                buf[pos++] = 61;
            }
            if (i < len) {
                c = data[i] & 0x3F;
                buf[pos++] = base64Chars[c];
            } else {
                buf[pos++] = 61;
            }
            if (lineBreak && i % 57 == 56) {
                buf[pos++] = 10;
            }
            ++i;
        }
        if (pos > 0 && lineBreak && buf[pos - 1] != '\n') {
            buf[pos] = 10;
        }
        return new String(buf, 0, pos);
    }

    public static String encodeBase64(byte[] data) {
        return StringUtils.encodeBase64(data, false);
    }

    public static byte[] decodeBase64(String data) {
        return StringUtils.decodeBase64(data, 0);
    }

    public static byte[] decodeBase64(String data, int offset) {
        if (data == null) {
            return null;
        }
        int len = data.length();
        byte[] result = new byte[len * 3 / 4];
        int pos = 0;
        if (offset >= len) {
            return null;
        }
        int i = offset;
        while (i < len) {
            int c = base64Codes[data.charAt(i)];
            if (c != -1) {
                int c1 = base64Codes[data.charAt(++i)];
                c = c << 2 | c1 >> 4 & 3;
                result[pos++] = (byte)c;
                if (++i < len) {
                    c = data.charAt(i);
                    if (61 == c) break;
                    c = base64Codes[data.charAt(i)];
                    c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                    result[pos++] = (byte)c1;
                }
                if (++i < len) {
                    c1 = data.charAt(i);
                    if (61 == c1) break;
                    c1 = base64Codes[data.charAt(i)];
                    c = c << 6 & 0xC0 | c1;
                    result[pos++] = (byte)c;
                }
            }
            ++i;
        }
        if (result.length != pos) {
            byte[] result2 = new byte[pos];
            System.arraycopy(result, 0, result2, 0, pos);
            result = result2;
        }
        return result;
    }

    public static char randomChar() {
        return numbersAndLetters[randGen.nextInt(numbersAndLetters.length)];
    }

    public static final String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        int i = 0;
        while (i < randBuffer.length) {
            randBuffer[i] = StringUtils.randomChar();
            ++i;
        }
        return new String(randBuffer);
    }

    public static String genEmptyString(int length) {
        char[] cs = new char[length];
        int i = 0;
        while (i < length) {
            cs[i] = 32;
            ++i;
        }
        return new String(cs);
    }

    public static boolean nullOrBlank(String param) {
        return param == null || param.trim().equals("");
    }

    public static int parseInt(String param, int defValue) {
        int i = defValue;
        try {
            i = Integer.parseInt(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static long parseLong(String param, long defValue) {
        long l = defValue;
        try {
            l = Long.parseLong(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static float parseFloat(String param, float defValue) {
        float f = defValue;
        try {
            f = Float.parseFloat(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static double parseDouble(String param, double defValue) {
        double d = defValue;
        try {
            d = Double.parseDouble(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static boolean parseBoolean(String param) {
        return StringUtils.parseBoolean(param, false);
    }

    public static boolean parseBoolean(String param, boolean value) {
        if (StringUtils.nullOrBlank(param)) {
            return value;
        }
        switch (param.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
            case '0': 
            case 'F': 
            case 'N': 
            case 'f': 
            case 'n': {
                return false;
            }
        }
        return value;
    }

    public static String encodeUrlString(String s) {
        return StringUtils.encodeUrlString(s, true);
    }

    public static String encodeUrlString(String s, boolean isUpper) {
        char[] hexChar = isUpper ? upcaseHexChar : lowerHexChar;
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == ' ') {
                sbuf.append('+');
            } else if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
            } else if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
            } else if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
            } else if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                sbuf.append(ch);
            } else if (ch <= '\u007f') {
                sbuf.append('%');
                sbuf.append(hexChar[ch >>> 4 & 0xF]);
                sbuf.append(hexChar[ch & 0xF]);
            } else {
                sbuf.append('%');
                sbuf.append('u');
                sbuf.append(hexChar[ch >>> 12 & 0xF]);
                sbuf.append(hexChar[ch >>> 8 & 0xF]);
                sbuf.append(hexChar[ch >>> 4 & 0xF]);
                sbuf.append(hexChar[ch & 0xF]);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String decodeUrlString(String s) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        int len = s.length();
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '+') {
                sbuf.append(' ');
            } else if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
            } else if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
            } else if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
            } else if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                sbuf.append(ch);
            } else if (ch == '%' && i < s.length() - 1) {
                int cint = 0;
                if ('%' == s.charAt(i + 1) || '\'' == s.charAt(i + 1)) {
                    sbuf.append(ch);
                } else {
                    if ('u' != s.charAt(i + 1)) {
                        cint = cint << 4 | hexCharCodes[s.charAt(i + 1)];
                        cint = cint << 4 | hexCharCodes[s.charAt(i + 2)];
                        i += 2;
                    } else {
                        cint = cint << 4 | hexCharCodes[s.charAt(i + 2)];
                        cint = cint << 4 | hexCharCodes[s.charAt(i + 3)];
                        cint = cint << 4 | hexCharCodes[s.charAt(i + 4)];
                        cint = cint << 4 | hexCharCodes[s.charAt(i + 5)];
                        i += 5;
                    }
                    sbuf.append((char)cint);
                }
            } else {
                sbuf.append(ch);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String join(Object[] list, String separator) {
        return StringUtils.join(Arrays.asList(list).iterator(), separator);
    }

    public static String join(Iterator iterator, String separator) {
        StringBuffer buf = new StringBuffer();
        while (iterator.hasNext()) {
            buf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String toEncoding(String strvalue, String fromEncoding, String toEncoding) {
        block3: {
            try {
                if (strvalue != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        strvalue = new String(strvalue.getBytes(fromEncoding), toEncoding);
        return strvalue;
    }

    public static String toChinese(String strvalue) {
        return StringUtils.toEncoding(strvalue, "ISO-8859-1", "GBK");
    }

    public static String toLatin(String strvalue) {
        return StringUtils.toEncoding(strvalue, "GBK", "ISO-8859-1");
    }

    public static int compareString(String s, String s2, String encoding) {
        if (s2 == null) {
            if (s != null) {
                return 1;
            }
            return 0;
        }
        if (s == null) {
            return -1;
        }
        try {
            byte[] v1 = s.getBytes(encoding);
            byte[] v2 = s2.getBytes(encoding);
            int i = v1.length;
            int j = v2.length;
            int n = Math.min(i, j);
            int k = 0;
            int lim = n;
            while (k < lim) {
                int c1 = v1[k] & 0xFF;
                int c2 = v2[k] & 0xFF;
                if (c1 != c2) {
                    return c1 - c2;
                }
                ++k;
            }
            return i - j;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String escapeString(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(len * 2);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\f': {
                    buf.append("\\f");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\u0000': {
                    buf.append("\\0");
                    break;
                }
                default: {
                    if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                        buf.append(ch);
                        break;
                    }
                    if (ch > '\u0100') {
                        buf.append('\\');
                        buf.append('u');
                        buf.append(upcaseHexChar[ch >> 12 & 0xF]);
                        buf.append(upcaseHexChar[ch >> 8 & 0xF]);
                        buf.append(upcaseHexChar[ch >> 4 & 0xF]);
                        buf.append(upcaseHexChar[ch >> 0 & 0xF]);
                        break;
                    }
                    buf.append('\\');
                    buf.append('x');
                    buf.append(upcaseHexChar[ch >> 4 & 0xF]);
                    buf.append(upcaseHexChar[ch >> 0 & 0xF]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean strEquals(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == s2;
    }

    public static String trimToByteSize(String s, String encoding, int btyeSize) {
        if (s != null) {
            int pos = 0;
            int charSize = 2;
            int strlen = s.length();
            if (encoding.charAt(0) == 'U') {
                charSize = 3;
            }
            int i = 0;
            while (i < strlen) {
                if (pos > btyeSize) {
                    return s.substring(0, i - 1);
                }
                pos = (s.charAt(i) & 0xFFFFFF00) != 0 ? (pos += charSize) : ++pos;
                ++i;
            }
        }
        return s;
    }

    public static boolean objectEquals(Object param0, Object pram1) {
        if (param0 != null && pram1 != null) {
            return param0.equals(pram1);
        }
        return param0 == null && pram1 == null;
    }

    public static String formatIpAddress(String ip, String port) {
        return String.format("%s|%s", ip.trim(), port.trim());
    }
}

