
![输入图片说明](https://images.gitee.com/uploads/images/2020/0705/083825_8bdcc48e_1038477.png "IOTGate_logo.png")
### IOTGate开源版（基于GPL-2.0开源，请自行阅读GPL-2.0相关条款）演示地址
	http://122.51.117.100:8686/
	
用户名密码随意输入：
![输入图片说明](https://images.gitee.com/uploads/images/2019/1025/220245_3ff17bcc_1038477.png "屏幕截图.png")
如果跳转报错则重新在地址栏输入http://122.51.117.100:8686/  即可正常访问！服务器资源有限，请不要对网关在线压测，谢谢！！
	
### 名词解释
通信规约：应用层通信协议，与有些同学说的的“通信协议”是一个意思

## 通过netty实现自定义协议物联网网关（单机和集群版）
window笔记本电脑本地测试：**单网关**、**单前置节点**，每秒处理并发心跳8000+（根据jmeter本地最新压测统计数据），20W在线终端(长连接保持)内存占用量1G左右

### 心跳检测
单机版可以通过配置文件个性化配置规约的心跳周期，集群版默认300秒
### 入口类:
	Entrance.java
	
### IOTGate操作指南--系列博客
於之博客：  https://www.xianglong.work/tag/IOTGate%E6%99%BA%E8%83%BD%E7%BD%91%E5%85%B3
	
於之CSDN: https://blog.csdn.net/sinat_28771747/category_8788959.html


### 命令行参数说明

|      参数      | 是否必选 |是否含参| 含义 |
|------------- |----------|----------|----------|
| 		-n	   |	是  | 是  | 网关编号  |
| 		-c	   |	否  | 否  | 启动集群模式  |
| 		-z	   |	否  | 是  | zookeeper集群地址  |
| 		-m	   |	否  | 是  | 前置ip地址(不含端口，前置默认8888)  |
| 		-f	   |	是  | 是  | 配置文件"iotGate.conf"的本地全路径   |

### 如何启动
自行将项目打成jar包，在linux下，执行java -jar iotGate.jar -n  1 [args...]  默认前置端口为8888，可自行源码中修改
 - 单机方式启动 ：命令行参数使用“-m”指定前置服务地址 
 - 集群方式启动：命令行参数“-c”开启zookeeper集群模式，“-z”指定zookeeper集群的地址（逗号分隔）
 - **单机版网关不支持IOTGateConsole控制台动态维护，因为IOTGateConsole的节点发现依赖于zookeeper,集群版网关无论节点多少依然可以通过IOTGateConsole管理**
### 自定义网关头结构与注意事项
 
 网关报头，是网关与前置通信时，作为网关登录和传输真实报文时携带网关自身和终端响应参数的报文，报文结构是自己定义，前置按照定义好的报文格式获取数据并做相应处理。
 网关头结构如下：
 
| 报文属性      | 字节数| 含义 |
|------------- | ------------- | ----------|
| 		AB			|		 1byte | 报文头 |
| 		len			|	     4byte | 长度域：真实报文长度，包含“68”，“16”|
| 		type		|		 1byte | 报头类型|
| 		protocolType|	     1byte | 协议类型（左侧起第一个bit为0 表示IPV4, 1表示IPV6  剩余7个bit表示规约类型编号）|
| 		gateNum		|         1byte | 网关编号|
| 		00*12		|		 12byte |如果ip格式为IPV4，则当前为12字节0，反之，当前得12个byte+后续得4byte存放IPV6的值，存放顺序从左至右依次|
| 		clientIP	|		 4byte | 终端的IP地址，ip地址的每个段位占一个字节（不含符号和端口号）|
|		port		|     2byte | 终端对应的端口号|
|		count		|     4byte | 终端与网关建立连接时对应的连接序号（1-10000循环）|
 		
网关发送需要向前置发送登录报文，将自己注册到前置服务中，报文说明如下：

- 1. 登录时长度为0；有真实报文时，长度域为整个真实报文长度值
- 2. 登录时type = 03；protocolType=15;count=1都为固定值；发送真实报文时，type=01,protocolType=00;count=终端与网关的连接序号
- 3. 前置发现报头长度为0 且type = 03; protocolType=15;就不会执行解析数据的方法，否则会继续解析真实报文

***************************************************************************************************************************

### 网关配置文件种默认支持的两种真实报文
	*“真实报文”即终端与网关通信时传输数据的报文，规约不同则报文结构差异明显
- 规约编号为“1”，报文结构如下

| 报文属性      | 字节数| 含义 |
|------------- | ------------- | ----------|
|68			|		 1byte  |   报头|
|		len			|		  2byte  |   长度域 "传输帧中除起始字符68和结束字符16之外的帧字节总数，包含长度域本身字节数"|
|		data				|	  n byte |  报文内容 |
|		16            |        1byte  |   报尾|
- 规约编号为“2”，报文结构如下

| 报文属性      | 字节数| 含义 |
|------------- | ------------- | ----------|
|		len			|		  4byte  |   长度域值为data的字节数，不包含自身字节数|
|		data				|	  n byte |  报文内容 |


***
### 版本规划
- IOTGate-v1.0 版本为集群版网关程序，通过命令行参数动态配置网关为单节点或集群（单节点不依赖zookeeper集群）  网关与前置通讯时默认轮询方式负载均衡
- IOTGate-v2.0.1.realease   IOTGate第一个正式稳定版本，可用于生产环境直接运行 !
- IOTGate-v2.0.2realease    解决了大家反应的一些bug，优化了内存泄漏异常，单机版本增加了配置单个规约心跳的配置选项，使得不同规约心跳的管理更加灵活！
- master 基本功能开发完成，已经支持多规约本地配置以及IOTGateConsole远程开启/关闭/新增/删除网关多规约服务功能。后续master会继续扩展相关功能
### 关于多规约支持
物联网虽然火起来，但目前业内还没有比较统一的通讯规约，MQTT是目前业界使用比较广泛的物联网通讯协议了，我看了下阿里最近弄出来的物联网平台其主要也是支持MQTT物联网设备的接入，但他毕竟不是唯一的通讯规约，光我自己知道的通讯都有好几种了，而且每一种规约的报文格式都各不相同，因此，所谓多规约支持，也不可能做到所有物联网规约全支持，我目前的想法是，通过多规约得基础功能和高级功能可以将比较流行物联网规约都能够支持！
那么IOTGate如何配置实现多规约支持呢？
IOTGate操作指南
### IOTGate功能架构图
![IOTGate开源版功能架构图](https://images.gitee.com/uploads/images/2019/1019/191425_eac2830b_1038477.jpeg "IOTGate开源版设计图模.jpg")
### GATE CLUSTER 结构图
![集群版IOTGate架构](https://images.gitee.com/uploads/images/2019/0325/101113_a6702fb6_1038477.jpeg "IOTGate.jpg")
注：GATE CLIENT（项目名称“IOTGateConsole”，项目地址：https://gitee.com/willbeahero/IOTGateConsole ） 是一个web工程，用户登录之后可以查看当前GATE CLUSTER的运行状态监控，并可执行网关重启、关闭、启动，网关多规约支持策略等操作：

![IOTGateConsole](https://images.gitee.com/uploads/images/2019/0331/152228_782eecd5_1038477.png "IOTGateConsole.png")
![规约维护](https://images.gitee.com/uploads/images/2019/0402/173605_1a4217c0_1038477.png "规约维护.png")
更多关于IOTGateConsole的说明请到博客中查看
### 计划新增功能（企业版已存在，根据企业版的应用情况回馈至开源社区）
- 单机规约心跳周期配置（已完成）
- 数据加密
- 启动类重构

### 联系方式
- QQ群：844082385（免费群）——仅限IOTGate技术交流，详见《进群须知》，加群前请先star本项目，您的支持是我长期坚持的根本动力！
### 关于大家捐赠本项目的资金用途问题说明
- 首先感谢大家对本项目一如既往的支持IOTGate，近期已经有朋友捐赠本项目，各位朋友捐赠到本项目的资金，如果后面足够购买云服务器的时候，我会用来购买一个云服务器用于部署本项目的一个演示版本，这样子也更方便大家！特此说明！
### 补充一点说明
- 项目相关文档我会全部写在我自己的博客里面，请大家参阅！谢谢大家的支持！！欢迎大家提供真实的使用案例

### 部分已知用户
#### 排名先后按联系作者时间顺序无特殊含义（欢迎其他使用该项目的优秀用户联系作者将贵公司名称加入本页）：

- 烟台华崟科技有限公司

- 深圳风扇屏技术有限公司

- 杭州物新驱动科技有限公司

### 浩欣泛在物联网云平台【简称：浩欣物联平台】  软著登记号：2020SR0374701 官网：www.uiotp.com
    #### 演示账号 guest001  密码 123456
    #### 简介

浩欣物联平台采用分布式微服务架构、分布式消息队列、分布式缓存、时序数据存储、流计算等技术实现的支持物联设备遥测数据采集、告警数据预警等功能的泛行业IOT物联网平台，可作为物联网上层应用的物联数据中台， 负责与各种不同规约类型的物联设备直接交互，并为上层应用提供统一的接口和响应数据格式能极大降低物联网研发的成本提高物联网研发效率。浩欣物联平台设备侧采用IOTGate企业版作为物联感知设备网络接入入口。
