/**
 * The MIT License
 *
 * Copyright for portions of unirest-java are held by Kong Inc (c) 2013.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package BehaviorTests;

import kong.unirest.JsonObjectMapper;
import kong.unirest.Unirest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

import static org.mockito.Matchers.anyString;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.verify;

class CustomObjectMapperTest extends BddTest {

    private JsonObjectMapper customOm;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        customOm = Mockito.spy(JsonObjectMapper.class);
    }

    @Test
    void canSetCustomObjectMapperOnConfig() {
        Unirest.config().setObjectMapper(customOm);

        Unirest.get(MockServer.GET)
                .asObject(RequestCapture.class);

        verify(customOm).readValue(anyString(), eq(RequestCapture.class));
    }

    @Test
    void canSetCustomObjectMapperOnRequest() {
        Unirest.get(MockServer.GET)
                .withObjectMapper(customOm)
                .asObject(RequestCapture.class);

        verify(customOm).readValue(anyString(), eq(RequestCapture.class));
    }
}
