// Copyright (c) 2019 GitHub, Inc.
// Use of this source code is governed by the MIT license that can be
// found in the LICENSE file.

#ifndef SHELL_COMMON_GIN_CONVERTERS_NATIVE_WINDOW_CONVERTER_H_
#define SHELL_COMMON_GIN_CONVERTERS_NATIVE_WINDOW_CONVERTER_H_

#include "gin/converter.h"
#include "shell/browser/api/electron_api_base_window.h"

namespace gin {

template <>
struct Converter<electron::NativeWindow*> {
  static bool FromV8(v8::Isolate* isolate,
                     v8::Local<v8::Value> val,
                     electron::NativeWindow** out) {
    // null would be transferred to NULL.
    if (val->IsNull()) {
      *out = NULL;
      return true;
    }

    electron::api::BaseWindow* window;
    if (!gin::Converter<electron::api::BaseWindow*>::FromV8(isolate, val,
                                                            &window))
      return false;
    *out = window->window();
    return true;
  }
};

}  // namespace gin

#endif  // SHELL_COMMON_GIN_CONVERTERS_NATIVE_WINDOW_CONVERTER_H_
