package com.publiccms.entities.cms;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * CmsCategory generated by hbm2java
 */
@Entity
@Table(name = "cms_category", uniqueConstraints = @UniqueConstraint(columnNames = { "site_id", "code" }))
@DynamicUpdate
public class CmsCategory implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "ID")
    private Integer id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    @GeneratorColumn(title = "名称")
    private String name;
    @GeneratorColumn(title = "父分类", condition = true)
    private Integer parentId;
    @GeneratorColumn(title = "分类类型", condition = true)
    private Integer typeId;
    @GeneratorColumn(title = "子分类")
    private String childIds;
    @GeneratorColumn(title = "标签ID")
    private String tagTypeIds;
    @GeneratorColumn(title = "编码")
    private String code;
    @GeneratorColumn(title = "模板路径")
    @JsonIgnore
    private String templatePath;
    @GeneratorColumn(title = "路径")
    @JsonIgnore
    private String path;
    @GeneratorColumn(title = "外链")
    private boolean onlyUrl;
    @GeneratorColumn(title = "有静态化")
    private boolean hasStatic;
    @GeneratorColumn(title = "地址")
    private String url;
    @GeneratorColumn(title = "内容路径")
    @JsonIgnore
    private String contentPath;
    @GeneratorColumn(title = "包含子分类内容")
    private boolean containChild;
    @GeneratorColumn(title = "每页数据")
    private Integer pageSize;
    @GeneratorColumn(title = "允许投稿", condition = true)
    private boolean allowContribute;
    @GeneratorColumn(title = "排序")
    private int sort;
    @GeneratorColumn(title = "是否隐藏", condition = true)
    private boolean hidden;
    @GeneratorColumn(title = "是否删除", condition = true)
    @JsonIgnore
    private boolean disabled;
    @GeneratorColumn(title = "扩展ID")
    private Integer extendId;

    public CmsCategory() {
    }

    public CmsCategory(short siteId, String name, String code, boolean onlyUrl, boolean hasStatic, boolean containChild,
            boolean allowContribute, int sort, boolean hidden, boolean disabled) {
        this.siteId = siteId;
        this.name = name;
        this.code = code;
        this.onlyUrl = onlyUrl;
        this.hasStatic = hasStatic;
        this.containChild = containChild;
        this.allowContribute = allowContribute;
        this.sort = sort;
        this.hidden = hidden;
        this.disabled = disabled;
    }

    public CmsCategory(short siteId, String name, Integer parentId, Integer typeId, String childIds, String tagTypeIds,
            String code, String templatePath, String path, boolean onlyUrl, boolean hasStatic, String url, String contentPath,
            boolean containChild, Integer pageSize, boolean allowContribute, int sort, boolean hidden, boolean disabled,
            Integer extendId) {
        this.siteId = siteId;
        this.name = name;
        this.parentId = parentId;
        this.typeId = typeId;
        this.childIds = childIds;
        this.tagTypeIds = tagTypeIds;
        this.code = code;
        this.templatePath = templatePath;
        this.path = path;
        this.onlyUrl = onlyUrl;
        this.hasStatic = hasStatic;
        this.url = url;
        this.contentPath = contentPath;
        this.containChild = containChild;
        this.pageSize = pageSize;
        this.allowContribute = allowContribute;
        this.sort = sort;
        this.hidden = hidden;
        this.disabled = disabled;
        this.extendId = extendId;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "name", nullable = false, length = 50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "parent_id")
    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    @Column(name = "type_id")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    @Column(name = "child_ids", length = 65535)
    public String getChildIds() {
        return this.childIds;
    }

    public void setChildIds(String childIds) {
        this.childIds = childIds;
    }

    @Column(name = "tag_type_ids", length = 65535)
    public String getTagTypeIds() {
        return this.tagTypeIds;
    }

    public void setTagTypeIds(String tagTypeIds) {
        this.tagTypeIds = tagTypeIds;
    }

    @Column(name = "code", nullable = false, length = 50)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name = "template_path")
    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    @Column(name = "path", length = 1000)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Column(name = "only_url", nullable = false)
    public boolean isOnlyUrl() {
        return this.onlyUrl;
    }

    public void setOnlyUrl(boolean onlyUrl) {
        this.onlyUrl = onlyUrl;
    }

    @Column(name = "has_static", nullable = false)
    public boolean isHasStatic() {
        return this.hasStatic;
    }

    public void setHasStatic(boolean hasStatic) {
        this.hasStatic = hasStatic;
    }

    @Column(name = "url", length = 1000)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "content_path", length = 1000)
    public String getContentPath() {
        return this.contentPath;
    }

    public void setContentPath(String contentPath) {
        this.contentPath = contentPath;
    }

    @Column(name = "contain_child", nullable = false)
    public boolean isContainChild() {
        return this.containChild;
    }

    public void setContainChild(boolean containChild) {
        this.containChild = containChild;
    }

    @Column(name = "page_size")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Column(name = "allow_contribute", nullable = false)
    public boolean isAllowContribute() {
        return this.allowContribute;
    }

    public void setAllowContribute(boolean allowContribute) {
        this.allowContribute = allowContribute;
    }

    @Column(name = "sort", nullable = false)
    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    @Column(name = "hidden", nullable = false)
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Column(name = "disabled", nullable = false)
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Column(name = "extend_id")
    public Integer getExtendId() {
        return this.extendId;
    }

    public void setExtendId(Integer extendId) {
        this.extendId = extendId;
    }

}
