package com.publiccms.entities.sys;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * AppClient generated by hbm2java
 */
@Entity
@Table(name = "sys_app_client", uniqueConstraints = @UniqueConstraint(columnNames = { "site_id", "channel", "uuid" }))
@DynamicUpdate
public class SysAppClient implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "ID")
    private Long id;
    private short siteId;
    private String channel;
    private String uuid;
    private Long userId;
    @GeneratorColumn(title = "版本")
    private String clientVersion;
    @GeneratorColumn(title = "上次登录日期", condition = true, order = true)
    private Date lastLoginDate;
    @GeneratorColumn(title = "上次登录IP")
    private String lastLoginIp;
    @GeneratorColumn(title = "创建日期", condition = true, order = true)
    private Date createDate;
    @GeneratorColumn(title = "已禁用", condition = true)
    @JsonIgnore
    private boolean disabled;

    public SysAppClient() {
    }

    public SysAppClient(short siteId, String channel, String uuid, Date createDate, boolean disabled) {
        this.siteId = siteId;
        this.channel = channel;
        this.uuid = uuid;
        this.createDate = createDate;
        this.disabled = disabled;
    }

    public SysAppClient(short siteId, String channel, String uuid, Long userId, String clientVersion, Date lastLoginDate,
            String lastLoginIp, Date createDate, boolean disabled) {
        this.siteId = siteId;
        this.channel = channel;
        this.uuid = uuid;
        this.userId = userId;
        this.clientVersion = clientVersion;
        this.lastLoginDate = lastLoginDate;
        this.lastLoginIp = lastLoginIp;
        this.createDate = createDate;
        this.disabled = disabled;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "channel", nullable = false, length = 20)
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Column(name = "uuid", nullable = false, length = 50)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "client_version", length = 50)
    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_login_date", length = 19)
    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    @Column(name = "last_login_ip", length = 64)
    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name = "disabled", nullable = false)
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

}
