/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.exporter;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.extensions.component.exporter.Exporter;
import org.primefaces.extensions.component.exporter.ExporterFactory;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression tableTitle;
    private ValueExpression encoding;
    private ValueExpression pageOnly;
    private ValueExpression selectionOnly;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;
    private ValueExpression isSubTable;
    private ValueExpression facetBackground;
    private ValueExpression facetFontSize;
    private ValueExpression facetFontColor;
    private ValueExpression facetFontStyle;
    private ValueExpression cellFontSize;
    private ValueExpression cellFontColor;
    private ValueExpression cellFontStyle;

    public DataExporter() {
    }

    public DataExporter(ValueExpression target, ValueExpression type, ValueExpression fileName, ValueExpression tableTitle, ValueExpression pageOnly, ValueExpression selectionOnly, ValueExpression encoding, MethodExpression preProcessor, MethodExpression postProcessor, ValueExpression isSubTable, ValueExpression facetBackground, ValueExpression facetFontSize, ValueExpression facetFontColor, ValueExpression facetFontStyle, ValueExpression cellFontSize, ValueExpression cellFontColor, ValueExpression cellFontStyle) {
        this.target = target;
        this.type = type;
        this.fileName = fileName;
        this.tableTitle = tableTitle;
        this.pageOnly = pageOnly;
        this.selectionOnly = selectionOnly;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.encoding = encoding;
        this.isSubTable = isSubTable;
        this.facetBackground = facetBackground;
        this.facetFontSize = facetFontSize;
        this.facetFontColor = facetFontColor;
        this.facetFontStyle = facetFontStyle;
        this.cellFontSize = cellFontSize;
        this.cellFontColor = cellFontColor;
        this.cellFontStyle = cellFontStyle;
    }

    public void processAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        String tableId = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        String tableTitleValue = "";
        if (this.tableTitle != null) {
            tableTitleValue = (String)this.tableTitle.getValue(elContext);
        }
        String encodingType = "UTF-8";
        if (this.encoding != null) {
            encodingType = (String)this.encoding.getValue(elContext);
        }
        boolean isPageOnly = false;
        if (this.pageOnly != null) {
            isPageOnly = this.pageOnly.isLiteralText() ? Boolean.valueOf(this.pageOnly.getValue(context.getELContext()).toString()) : (Boolean)this.pageOnly.getValue(context.getELContext());
        }
        boolean isSelectionOnly = false;
        if (this.selectionOnly != null) {
            isSelectionOnly = this.selectionOnly.isLiteralText() ? Boolean.valueOf(this.selectionOnly.getValue(context.getELContext()).toString()) : (Boolean)this.selectionOnly.getValue(context.getELContext());
        }
        boolean isSubtable = false;
        if (this.isSubTable != null) {
            isSubtable = this.isSubTable.isLiteralText() ? Boolean.valueOf(this.isSubTable.getValue(context.getELContext()).toString()) : (Boolean)this.isSubTable.getValue(context.getELContext());
        }
        String facetBackgroundValue = "#FFFFFF";
        if (this.facetBackground != null) {
            facetBackgroundValue = (String)this.facetBackground.getValue(elContext);
        }
        String facetFontSizeValue = "10";
        if (this.facetFontSize != null) {
            facetFontSizeValue = (String)this.facetFontSize.getValue(elContext);
        }
        String facetFontColorValue = "#000000";
        if (this.facetFontColor != null) {
            facetFontColorValue = (String)this.facetFontColor.getValue(elContext);
        }
        String facetFontStyleValue = "BOLD";
        if (this.facetFontStyle != null) {
            facetFontStyleValue = (String)this.facetFontStyle.getValue(elContext);
        }
        String cellFontSizeValue = "8";
        if (this.cellFontSize != null) {
            cellFontSizeValue = (String)this.cellFontSize.getValue(elContext);
        }
        String cellFontColorValue = "#000000";
        if (this.cellFontColor != null) {
            cellFontColorValue = (String)this.cellFontColor.getValue(elContext);
        }
        String cellFontStyleValue = "NORMAL";
        if (this.cellFontStyle != null) {
            cellFontStyleValue = (String)this.cellFontStyle.getValue(elContext);
        }
        try {
            Exporter exporter = ExporterFactory.getExporterForType(exportAs);
            exporter.customFormat(facetBackgroundValue, facetFontSizeValue, facetFontColorValue, facetFontStyleValue, cellFontSizeValue, cellFontColorValue, cellFontStyleValue);
            exporter.export(event, tableId, context, outputFileName, tableTitleValue, isPageOnly, isSelectionOnly, encodingType, this.preProcessor, this.postProcessor, isSubtable);
            context.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private int[] resolveExcludedColumnIndexes(Object columnsToExclude) {
        if (columnsToExclude == null || columnsToExclude.equals("")) {
            return null;
        }
        String[] columnIndexesAsString = ((String)columnsToExclude).split(",");
        int[] indexes = new int[columnIndexesAsString.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Integer.parseInt(columnIndexesAsString[i].trim());
        }
        return indexes;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.tableTitle = (ValueExpression)values[3];
        this.pageOnly = (ValueExpression)values[4];
        this.selectionOnly = (ValueExpression)values[5];
        this.preProcessor = (MethodExpression)values[6];
        this.postProcessor = (MethodExpression)values[7];
        this.encoding = (ValueExpression)values[8];
        this.isSubTable = (ValueExpression)values[9];
        this.facetBackground = (ValueExpression)values[10];
        this.facetFontSize = (ValueExpression)values[11];
        this.facetFontColor = (ValueExpression)values[12];
        this.facetFontStyle = (ValueExpression)values[13];
        this.cellFontSize = (ValueExpression)values[14];
        this.cellFontColor = (ValueExpression)values[15];
        this.cellFontStyle = (ValueExpression)values[16];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.type, this.fileName, this.tableTitle, this.pageOnly, this.selectionOnly, this.preProcessor, this.postProcessor, this.encoding, this.isSubTable, this.facetBackground, this.facetFontSize, this.facetFontColor, this.facetFontStyle, this.cellFontSize, this.cellFontColor, this.cellFontStyle};
        return values;
    }
}

