/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.exporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.ActionEvent;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.roweditor.RowEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Exporter {
    public abstract void export(ActionEvent var1, String var2, FacesContext var3, String var4, String var5, boolean var6, boolean var7, String var8, MethodExpression var9, MethodExpression var10, boolean var11) throws IOException;

    public abstract void customFormat(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException;

    protected List<UIColumn> getColumnsToExport(UIData table) {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        int columnIndex = -1;
        for (UIComponent child : table.getChildren()) {
            if (!(child instanceof UIColumn)) continue;
            UIColumn column = (UIColumn)child;
            ++columnIndex;
            columns.add(column);
        }
        return columns;
    }

    protected boolean hasColumnFooter(List<UIColumn> columns) {
        for (UIColumn column : columns) {
            if (column.getFooter() == null) continue;
            return true;
        }
        return false;
    }

    protected String exportValue(FacesContext context, UIComponent component) {
        if (component instanceof CellEditor) {
            return this.exportValue(context, component.getFacet("output"));
        }
        if (component instanceof RowEditor) {
            return "RowEditor";
        }
        if (component instanceof HtmlGraphicImage) {
            return (String)component.getAttributes().get("alt");
        }
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof HtmlCommandButton) {
            HtmlCommandButton button = (HtmlCommandButton)component;
            Object value = button.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : button.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof HtmlSelectOneMenu) {
            HtmlSelectOneMenu oneMenu = (HtmlSelectOneMenu)component;
            Object value = oneMenu.getSubmittedValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : oneMenu.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof ValueHolder) {
            Converter converterForType;
            Class valueType;
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(context, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(context.getELContext())) != null && (converterForType = context.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(context, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }
}

