/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.exporter;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.row.Row;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.extensions.component.exporter.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFExporter
extends Exporter {
    private Font cellFont;
    private Font facetFont;
    private Color facetBackground;
    private Float facetFontSize;
    private Color facetFontColor;
    private String facetFontStyle;
    private Float cellFontSize;
    private Color cellFontColor;
    private String cellFontStyle;

    @Override
    public void export(ActionEvent event, String tableId, FacesContext context, String filename, String tableTitle, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean isSubTable) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            StringTokenizer st = new StringTokenizer(tableId, ",");
            while (st.hasMoreElements()) {
                PdfPTable pdf;
                String tableName = (String)st.nextElement();
                UIComponent component = event.getComponent().findComponent(tableName);
                if (component == null) {
                    throw new FacesException("Cannot find component \"" + tableName + "\" in view.");
                }
                if (!(component instanceof DataTable)) {
                    throw new FacesException("Unsupported datasource target:\"" + component.getClass().getName() + "\", exporter must target a PrimeFaces DataTable.");
                }
                DataTable table = (DataTable)component;
                if (preProcessor != null) {
                    preProcessor.invoke(context.getELContext(), new Object[]{document});
                }
                if (!document.isOpen()) {
                    document.open();
                }
                if (tableTitle != null && !tableTitle.isEmpty() && !tableId.contains(",")) {
                    Font tableTitleFont = FontFactory.getFont((String)"Times", (String)"UTF-8", (float)12.0f, (int)1);
                    Paragraph title = new Paragraph(tableTitle, tableTitleFont);
                    document.add((Element)title);
                    Paragraph preface = new Paragraph();
                    PDFExporter.addEmptyLine(preface, 3);
                    document.add((Element)preface);
                }
                if ((pdf = this.exportPDFTable(context, table, pageOnly, selectionOnly, encodingType, isSubTable)) != null) {
                    document.add((Element)pdf);
                }
                Paragraph preface = new Paragraph();
                PDFExporter.addEmptyLine(preface, 7);
                document.add((Element)preface);
                if (postProcessor == null) continue;
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, filename);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void customFormat(String facetBackground, String facetFontSize, String facetFontColor, String facetFontStyle, String cellFontSize, String cellFontColor, String cellFontStyle) {
        this.facetBackground = Color.decode(facetBackground);
        this.facetFontSize = new Float(facetFontSize);
        this.facetFontColor = Color.decode(facetFontColor);
        if (facetFontStyle.equalsIgnoreCase("NORMAL")) {
            this.facetFontStyle = "" + 0;
        }
        if (facetFontStyle.equalsIgnoreCase("BOLD")) {
            this.facetFontStyle = "" + 1;
        }
        if (facetFontStyle.equalsIgnoreCase("ITALIC")) {
            this.facetFontStyle = "" + 2;
        }
        this.cellFontSize = new Float(cellFontSize);
        this.cellFontColor = Color.decode(cellFontColor);
        if (cellFontStyle.equalsIgnoreCase("NORMAL")) {
            this.cellFontStyle = "" + 0;
        }
        if (cellFontStyle.equalsIgnoreCase("BOLD")) {
            this.cellFontStyle = "" + 1;
        }
        if (cellFontStyle.equalsIgnoreCase("ITALIC")) {
            this.cellFontStyle = "" + 2;
        }
    }

    protected PdfPTable exportPDFTable(FacesContext context, DataTable table, boolean pageOnly, boolean selectionOnly, String encoding, boolean isSubTable) {
        this.cellFont = FontFactory.getFont((String)"Times", (String)encoding);
        this.facetFont = FontFactory.getFont((String)"Times", (String)encoding, (float)12.0f, (int)1);
        if (this.cellFontColor != null) {
            this.cellFont.setColor(this.cellFontColor);
        }
        if (this.cellFontSize != null) {
            this.cellFont.setSize(this.cellFontSize.floatValue());
        }
        if (this.cellFontStyle != null) {
            this.cellFont.setStyle(this.cellFontStyle);
        }
        if (this.facetFontColor != null) {
            this.facetFont.setColor(this.facetFontColor);
        }
        if (this.facetFontSize != null) {
            this.facetFont.setSize(10.0f);
        }
        if (this.facetFontStyle != null) {
            this.facetFont.setStyle(this.facetFontStyle);
        }
        int columnsCount = this.getColumnsCount(table);
        PdfPTable pdfTable = null;
        if (isSubTable) {
            int subTableCount = table.getRowCount();
            SubTable subtable = table.getSubTable();
            int subTableColumnsCount = this.getColumnsCount(subtable);
            pdfTable = new PdfPTable(subTableColumnsCount);
            if (table.getHeader() != null) {
                this.tableFacet(context, pdfTable, table, subTableColumnsCount, "header");
            }
            this.tableColumnGroup(pdfTable, table, "header");
            int i = 0;
            while (subTableCount > 0) {
                --subTableCount;
                table.setRowIndex(i);
                ++i;
                subtable = table.getSubTable();
                if (subtable.getHeader() != null) {
                    this.tableFacet(context, pdfTable, subtable, subTableColumnsCount, "header");
                }
                if (this.hasHeaderColumn(subtable)) {
                    this.addColumnFacets(subtable, pdfTable, Exporter.ColumnType.HEADER);
                }
                if (pageOnly) {
                    this.exportPageOnly(context, table, pdfTable);
                } else if (selectionOnly) {
                    this.exportSelectionOnly(context, table, pdfTable);
                } else {
                    this.subTableExportAll(context, subtable, pdfTable);
                }
                if (this.hasFooterColumn(subtable)) {
                    this.addColumnFacets(subtable, pdfTable, Exporter.ColumnType.FOOTER);
                }
                if (subtable.getFooter() != null) {
                    this.tableFacet(context, pdfTable, subtable, subTableColumnsCount, "footer");
                }
                subtable.setRowIndex(-1);
            }
            this.tableColumnGroup(pdfTable, table, "footer");
            if (table.hasFooterColumn()) {
                this.tableFacet(context, pdfTable, table, subTableColumnsCount, "footer");
            }
            return pdfTable;
        }
        if (columnsCount != 0) {
            pdfTable = new PdfPTable(columnsCount);
            if (table.getHeader() != null) {
                this.tableFacet(context, pdfTable, table, columnsCount, "header");
            }
            if (this.hasHeaderColumn(table)) {
                this.addColumnFacets(table, pdfTable, Exporter.ColumnType.HEADER);
            }
            if (pageOnly) {
                this.exportPageOnly(context, table, pdfTable);
            } else if (selectionOnly) {
                this.exportSelectionOnly(context, table, pdfTable);
            } else {
                this.exportAll(context, table, pdfTable);
            }
            if (table.hasFooterColumn()) {
                this.addColumnFacets(table, pdfTable, Exporter.ColumnType.FOOTER);
            }
            if (table.getFooter() != null) {
                this.tableFacet(context, pdfTable, table, columnsCount, "footer");
            }
            table.setRowIndex(-1);
            return pdfTable;
        }
        return null;
    }

    public int getSubTableCount(List<UIComponent> list) {
        int count = 0;
        for (UIComponent kid : list) {
            if (!(kid instanceof SubTable)) continue;
            ++count;
        }
        return count;
    }

    protected void exportPageOnly(FacesContext context, DataTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        this.tableColumnGroup(pdfTable, table, "header");
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, pdfTable, rowIndex);
        }
        this.tableColumnGroup(pdfTable, table, "footer");
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, PdfPTable pdfTable) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportCells(table, pdfTable);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, pdfTable);
            }
        }
    }

    protected void exportAll(FacesContext context, DataTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (rowIndex % rows == 0) {
                    table.setFirst(rowIndex);
                    table.loadLazyData();
                }
                this.exportRow(table, pdfTable, rowIndex);
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            this.tableColumnGroup(pdfTable, table, "header");
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, pdfTable, rowIndex);
            }
            this.tableColumnGroup(pdfTable, table, "footer");
            table.setFirst(first);
        }
    }

    protected void subTableExportAll(FacesContext context, SubTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = false;
        if (lazy) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (rowIndex % rows != 0) continue;
                table.setFirst(rowIndex);
            }
            table.setFirst(first);
        } else {
            this.tableColumnGroup(pdfTable, table, "header");
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.subTableExportRow(table, pdfTable, rowIndex);
            }
            this.tableColumnGroup(pdfTable, table, "footer");
            table.setFirst(first);
        }
    }

    protected void tableFacet(FacesContext context, PdfPTable pdfTable, DataTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue = null;
            headerValue = component instanceof HtmlCommandButton ? this.exportValue(context, component) : (component instanceof HtmlCommandLink ? this.exportValue(context, component) : this.exportFacetValue(context, component));
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(headerValue, this.facetFont));
            if (this.facetBackground != null) {
                cell.setBackgroundColor(this.facetBackground);
            }
            cell.setHorizontalAlignment(1);
            cell.setColspan(columnCount);
            pdfTable.addCell(cell);
            pdfTable.completeRow();
        }
    }

    protected void tableFacet(FacesContext context, PdfPTable pdfTable, SubTable table, int columnCount, String facetType) {
        Map map = table.getFacets();
        UIComponent component = (UIComponent)map.get(facetType);
        if (component != null) {
            String headerValue = null;
            headerValue = component instanceof HtmlCommandButton ? this.exportValue(context, component) : (component instanceof HtmlCommandLink ? this.exportValue(context, component) : this.exportFacetValue(context, component));
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(headerValue, this.facetFont));
            if (this.facetBackground != null) {
                cell.setBackgroundColor(this.facetBackground);
            }
            cell.setHorizontalAlignment(0);
            cell.setColspan(columnCount);
            pdfTable.addCell(cell);
            pdfTable.completeRow();
        }
    }

    protected void tableColumnGroup(PdfPTable pdfTable, DataTable table, String facetType) {
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof Row)) continue;
                Row row = (Row)component;
                for (UIComponent rowComponent : row.getChildren()) {
                    UIColumn column = (UIColumn)rowComponent;
                    String value = null;
                    value = facetType.equalsIgnoreCase("header") ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
                    if (this.facetBackground != null) {
                        cell.setBackgroundColor(this.facetBackground);
                    }
                    if (rowSpan > 1) {
                        cell.setVerticalAlignment(1);
                        cell.setRowspan(rowSpan);
                    }
                    if (colSpan > 1) {
                        cell.setHorizontalAlignment(1);
                        cell.setColspan(colSpan);
                    }
                    pdfTable.addCell(cell);
                }
            }
        }
        pdfTable.completeRow();
    }

    protected void tableColumnGroup(PdfPTable pdfTable, SubTable table, String facetType) {
        ColumnGroup cg = table.getColumnGroup(facetType);
        List headerComponentList = null;
        if (cg != null) {
            headerComponentList = cg.getChildren();
        }
        if (headerComponentList != null) {
            for (UIComponent component : headerComponentList) {
                if (!(component instanceof Row)) continue;
                Row row = (Row)component;
                for (UIComponent rowComponent : row.getChildren()) {
                    UIColumn column = (UIColumn)rowComponent;
                    String value = null;
                    value = facetType.equalsIgnoreCase("header") ? column.getHeaderText() : column.getFooterText();
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
                    if (this.facetBackground != null) {
                        cell.setBackgroundColor(this.facetBackground);
                    }
                    if (rowSpan > 1) {
                        cell.setVerticalAlignment(1);
                        cell.setRowspan(rowSpan);
                    }
                    if (colSpan > 1) {
                        cell.setHorizontalAlignment(1);
                        cell.setColspan(colSpan);
                    }
                    pdfTable.addCell(cell);
                }
            }
        }
        pdfTable.completeRow();
    }

    protected String exportFacetValue(FacesContext context, UIComponent component) {
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(context, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public boolean hasHeaderColumn(DataTable table) {
        for (UIComponent child : table.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("header") == null && column.getHeaderText() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasHeaderColumn(SubTable table) {
        for (UIComponent child : table.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("header") == null && column.getHeaderText() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasFooterColumn(SubTable table) {
        for (UIComponent child : table.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("footer") == null && column.getHeaderText() == null) continue;
            return true;
        }
        return false;
    }

    protected void exportRow(DataTable table, PdfPTable pdfTable, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, pdfTable);
        SummaryRow sr = table.getSummaryRow();
        if (sr != null && sr.isInView()) {
            for (UIComponent summaryComponent : sr.getChildren()) {
                UIColumn column = (UIColumn)summaryComponent;
                StringBuilder builder = new StringBuilder();
                for (UIComponent component : column.getChildren()) {
                    String value;
                    if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
                    builder.append(value);
                }
                int rowSpan = column.getRowspan();
                int colSpan = column.getColspan();
                PdfPCell cell = new PdfPCell((Phrase)new Paragraph(builder.toString(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                if (rowSpan > 1) {
                    cell.setVerticalAlignment(1);
                    cell.setRowspan(rowSpan);
                }
                if (colSpan > 1) {
                    cell.setHorizontalAlignment(1);
                    cell.setColspan(colSpan);
                }
                pdfTable.addCell(cell);
            }
        }
    }

    protected void subTableExportRow(SubTable table, PdfPTable pdfTable, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.subTableExportCells(table, pdfTable);
    }

    protected void exportCells(DataTable table, PdfPTable pdfTable) {
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) continue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            if (col.getSelectionMode() != null) {
                pdfTable.addCell((Phrase)new Paragraph(col.getSelectionMode(), this.cellFont));
                continue;
            }
            this.addColumnValue(pdfTable, col.getChildren(), this.cellFont);
        }
    }

    protected void subTableExportCells(SubTable table, PdfPTable pdfTable) {
        for (Column col : table.getColumns()) {
            if (!col.isRendered()) continue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            this.addColumnValue(pdfTable, col.getChildren(), this.cellFont);
        }
    }

    protected void addColumnFacets(DataTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) continue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            PdfPCell cell = null;
            if (!col.isExportable()) continue;
            if (col.getHeaderText() != null && columnType.name().equalsIgnoreCase("header")) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getHeaderText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            if (col.getFooterText() != null && columnType.name().equalsIgnoreCase("footer")) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getFooterText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            this.addColumnValue(pdfTable, col.getFacet(columnType.facet()), this.facetFont);
        }
    }

    protected void addColumnFacets(SubTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (Column col : table.getColumns()) {
            if (!col.isRendered()) continue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            PdfPCell cell = null;
            if (!col.isExportable()) continue;
            if (col.getHeaderText() != null && columnType.name().equalsIgnoreCase("header")) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getHeaderText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            if (col.getFooterText() != null && columnType.name().equalsIgnoreCase("footer")) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getFooterText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            this.addColumnValue(pdfTable, col.getFacet(columnType.facet()), this.facetFont);
        }
    }

    protected void addSubTableColumnFacets(SubTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (Column col : table.getColumns()) {
            if (!col.isRendered()) continue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            PdfPCell cell = null;
            if (!col.isExportable()) continue;
            if (col.getHeaderText() != null && columnType.name().equalsIgnoreCase("header")) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getHeaderText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            if (col.getFooterText() != null && columnType.name().equalsIgnoreCase("footer")) {
                cell = new PdfPCell((Phrase)new Paragraph(col.getFooterText(), this.facetFont));
                if (this.facetBackground != null) {
                    cell.setBackgroundColor(this.facetBackground);
                }
                pdfTable.addCell(cell);
                continue;
            }
            this.addColumnValue(pdfTable, col.getFacet(columnType.facet()), this.facetFont);
        }
    }

    protected void addColumnValue(PdfPTable pdfTable, UIComponent component, Font font) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, font));
        if (this.facetBackground != null) {
            cell.setBackgroundColor(this.facetBackground);
        }
        pdfTable.addCell(cell);
    }

    protected void addColumnValue(PdfPTable pdfTable, List<UIComponent> components, Font font) {
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        pdfTable.addCell((Phrase)new Paragraph(builder.toString(), font));
    }

    protected void writePDFToResponse(ExternalContext externalContext, ByteArrayOutputStream baos, String fileName) throws IOException, DocumentException {
        externalContext.setResponseContentType("application/pdf");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
        externalContext.setResponseContentLength(baos.size());
        externalContext.addResponseCookie("primefaces.download", "true", new HashMap());
        OutputStream out = externalContext.getResponseOutputStream();
        baos.writeTo(out);
        externalContext.responseFlushBuffer();
    }

    private static void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Object)new Paragraph(" "));
        }
    }

    protected int getColumnsCount(DataTable table) {
        int count = 0;
        for (UIComponent child : table.getChildren()) {
            Columns columns;
            if (!child.isRendered()) continue;
            if (child instanceof Column) {
                Column column = (Column)child;
                if (!column.isExportable()) continue;
                ++count;
                continue;
            }
            if (!(child instanceof Columns) || !(columns = (Columns)child).isExportable()) continue;
            count += columns.getRowCount();
        }
        return count;
    }

    protected int getColumnsCount(SubTable table) {
        int count = 0;
        for (UIComponent child : table.getChildren()) {
            Columns columns;
            if (!child.isRendered()) continue;
            if (child instanceof Column) {
                Column column = (Column)child;
                if (!column.isExportable()) continue;
                ++count;
                continue;
            }
            if (!(child instanceof Columns) || !(columns = (Columns)child).isExportable()) continue;
            count += columns.getRowCount();
        }
        return count;
    }
}

