/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.keyfilter;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.keyfilter.KeyFilter;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.renderkit.CoreRenderer;

public class KeyFilterRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        KeyFilter keyFilter = (KeyFilter)component;
        String clientId = keyFilter.getClientId(context);
        String widgetVar = keyFilter.resolveWidgetVar();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('KeyFilter', '" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",target:'" + ComponentUtils.findTarget(context, keyFilter) + "'");
        if (keyFilter.getRegEx() != null) {
            writer.write(",regEx:" + keyFilter.getRegEx());
        } else if (keyFilter.getMask() != null) {
            writer.write(",mask:'" + keyFilter.getMask() + "'");
        } else if (keyFilter.getTestFunction() != null) {
            writer.write(",testFunction:function(c){" + keyFilter.getTestFunction() + ";}");
        }
        if (keyFilter.getPreventPaste() != null) {
            writer.write(",preventPaste:" + keyFilter.getPreventPaste());
        }
        writer.write("});});");
        this.endScript(writer);
    }
}

